/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.SingularAttribute;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.rest.core.Handler;
import org.springframework.data.rest.core.SimpleLink;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.JpaEntityMetadata;
import org.springframework.data.rest.repository.JpaRepositoryMetadata;
import org.springframework.data.rest.webmvc.Links;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;

@Controller
public class RepositoryRestController
implements InitializingBean {
    public static final String STATUS = "status";
    public static final String HEADERS = "headers";
    public static final String LOCATION = "Location";
    public static final String RESOURCE = "resource";
    public static final String SELF = "self";
    public static final String LINKS = "_links";
    private MediaType uriListMediaType = MediaType.parseMediaType((String)"text/uri-list");
    private MediaType jsonMediaType = MediaType.parseMediaType((String)"application/x-spring-data+json");
    private JpaRepositoryMetadata repositoryMetadata;
    private Map<CrudRepository, TypeMetaCacheEntry> typeMetaCache = new ConcurrentHashMap<CrudRepository, TypeMetaCacheEntry>();
    private ConversionService conversionService = new DefaultConversionService();
    private List<HttpMessageConverter<?>> httpMessageConverters;
    private ObjectMapper objectMapper = new ObjectMapper();

    public JpaRepositoryMetadata getRepositoryMetadata() {
        return this.repositoryMetadata;
    }

    public void setRepositoryMetadata(JpaRepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
    }

    public JpaRepositoryMetadata repositoryMetadata() {
        return this.repositoryMetadata;
    }

    public RepositoryRestController repositoryMetadata(JpaRepositoryMetadata repositoryMetadata) {
        this.repositoryMetadata = repositoryMetadata;
        return this;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public ConversionService conversionService() {
        return this.conversionService;
    }

    public RepositoryRestController conversionService(ConversionService conversionService) {
        this.conversionService = conversionService;
        return this;
    }

    public List<HttpMessageConverter<?>> getHttpMessageConverters() {
        return this.httpMessageConverters;
    }

    public void setHttpMessageConverters(List<HttpMessageConverter<?>> httpMessageConverters) {
        this.httpMessageConverters = httpMessageConverters;
    }

    public List<HttpMessageConverter<?>> httpMessageConverters() {
        return this.httpMessageConverters;
    }

    public RepositoryRestController httpMessageConverters(List<HttpMessageConverter<?>> httpMessageConverters) {
        this.httpMessageConverters = httpMessageConverters;
        return this;
    }

    public MediaType getUriListMediaType() {
        return this.uriListMediaType;
    }

    public void setUriListMediaType(MediaType uriListMediaType) {
        this.uriListMediaType = uriListMediaType;
    }

    public void setUriListMediaType(String uriListMediaType) {
        this.uriListMediaType = MediaType.valueOf((String)uriListMediaType);
    }

    public MediaType uriListMediaType() {
        return this.uriListMediaType;
    }

    public RepositoryRestController uriListMediaType(MediaType uriListMediaType) {
        this.setUriListMediaType(uriListMediaType);
        return this;
    }

    public RepositoryRestController uriListMediaType(String uriListMediaType) {
        this.setUriListMediaType(uriListMediaType);
        return this;
    }

    public MediaType getJsonMediaType() {
        return this.jsonMediaType;
    }

    public void setJsonMediaType(MediaType jsonMediaType) {
        this.jsonMediaType = jsonMediaType;
    }

    public void setJsonMediaType(String jsonMediaType) {
        this.jsonMediaType = MediaType.valueOf((String)jsonMediaType);
    }

    public MediaType jsonMediaType() {
        return this.jsonMediaType;
    }

    public RepositoryRestController jsonMediaType(MediaType jsonMediaType) {
        this.setJsonMediaType(jsonMediaType);
        return this;
    }

    public RepositoryRestController jsonMediaType(String jsonMediaType) {
        this.setJsonMediaType(jsonMediaType);
        return this;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull(this.httpMessageConverters, (String)"HttpMessageConverters cannot be null");
    }

    @RequestMapping(value={"/"}, method={RequestMethod.GET}, produces={"application/json"})
    public void listRepositories(UriComponentsBuilder uriBuilder, Model model) {
        URI baseUri = uriBuilder.build().toUri();
        Links links = new Links();
        for (String name : this.repositoryMetadata.repositoryNames()) {
            links.add(new SimpleLink(name, RepositoryRestController.buildUri(baseUri, name)));
        }
        model.addAttribute(STATUS, (Object)HttpStatus.OK);
        model.addAttribute(RESOURCE, (Object)links);
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET}, produces={"application/json"})
    public void listEntities(UriComponentsBuilder uriBuilder, @PathVariable String repository, Model model) {
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Links links = new Links();
        for (Object o : repo.findAll()) {
            Serializable id = typeMeta.entityInfo.getId(o);
            links.add(new SimpleLink(o.getClass().getSimpleName(), RepositoryRestController.buildUri(baseUri, repository, id.toString())));
        }
        model.addAttribute(STATUS, (Object)HttpStatus.OK);
        model.addAttribute(RESOURCE, (Object)links);
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.POST}, produces={"application/json"})
    public void create(ServerHttpRequest request, UriComponentsBuilder uriBuilder, @PathVariable String repository, Model model) throws IOException {
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_IMPLEMENTED);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        MediaType incomingMediaType = request.getHeaders().getContentType();
        Object incoming = this.readIncoming((HttpInputMessage)request, incomingMediaType, typeMeta.domainClass);
        if (null == incoming) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_ACCEPTABLE);
        } else {
            Object savedEntity = repo.save(incoming);
            String sId = typeMeta.entityInfo.getId(savedEntity).toString();
            URI selfUri = RepositoryRestController.buildUri(baseUri, repository, sId);
            HttpHeaders headers = new HttpHeaders();
            headers.set(LOCATION, selfUri.toString());
            model.addAttribute(HEADERS, (Object)headers);
            model.addAttribute(STATUS, (Object)HttpStatus.CREATED);
        }
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET}, produces={"application/json"})
    public void entity(ServerHttpRequest request, UriComponentsBuilder uriBuilder, @PathVariable String repository, @PathVariable String id, Model model) {
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        Object entity = repo.findOne(serId);
        if (null == entity) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
        } else {
            HttpHeaders headers = new HttpHeaders();
            Object version = typeMeta.entityMetadata.version(entity);
            if (null != version) {
                List etags = request.getHeaders().getIfNoneMatch();
                for (String etag : etags) {
                    if (!("\"" + version.toString() + "\"").equals(etag)) continue;
                    model.addAttribute(STATUS, (Object)HttpStatus.NOT_MODIFIED);
                    return;
                }
                headers.set("ETag", "\"" + version.toString() + "\"");
            }
            Map<String, Object> entityDto = this.extractPropertiesLinkAware(entity, typeMeta.entityMetadata, UriComponentsBuilder.fromUri((URI)baseUri).pathSegment(new String[]{repository, id}).build().toUri());
            this.addSelfLink(baseUri, entityDto, repository, id);
            model.addAttribute(HEADERS, (Object)headers);
            model.addAttribute(STATUS, (Object)HttpStatus.OK);
            model.addAttribute(RESOURCE, entityDto);
        }
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PUT, RequestMethod.POST}, consumes={"application/json"}, produces={"application/json"})
    public void createOrUpdate(ServerHttpRequest request, UriComponentsBuilder uriBuilder, @PathVariable String repository, @PathVariable String id, Model model) throws IOException, IllegalAccessException, InstantiationException {
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_IMPLEMENTED);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        Object entity = null;
        switch (request.getMethod()) {
            case POST: {
                entity = typeMeta.domainClass.newInstance();
                break;
            }
            case PUT: {
                entity = repo.findOne(serId);
            }
        }
        if (null == entity) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
        } else {
            MediaType incomingMediaType = request.getHeaders().getContentType();
            Object incoming = this.readIncoming((HttpInputMessage)request, incomingMediaType, typeMeta.domainClass);
            if (null == incoming) {
                throw new HttpMessageNotReadableException("Could not create an instance of " + typeMeta.domainClass.getSimpleName() + " from input.");
            }
            typeMeta.entityMetadata.id(serId, incoming);
            if (request.getMethod() == HttpMethod.POST) {
                repo.save(incoming);
                URI selfUri = RepositoryRestController.buildUri(baseUri, repository, id);
                HttpHeaders headers = new HttpHeaders();
                headers.set(LOCATION, selfUri.toString());
                model.addAttribute(HEADERS, (Object)headers);
                model.addAttribute(STATUS, (Object)HttpStatus.CREATED);
            } else {
                repo.save(incoming);
                model.addAttribute(STATUS, (Object)HttpStatus.NO_CONTENT);
            }
        }
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.DELETE})
    public void deleteEntity(@PathVariable String repository, @PathVariable String id, Model model) {
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        repo.delete(serId);
        model.addAttribute(STATUS, (Object)HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET}, produces={"application/json", "text/uri-list"})
    public void propertyOfEntity(UriComponentsBuilder uriBuilder, @PathVariable String repository, @PathVariable String id, @PathVariable String property, Model model) {
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        Object entity = repo.findOne(serId);
        if (null == entity) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
        } else {
            Attribute attr = typeMeta.entityType.getAttribute(property);
            if (null == attr) {
                model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            } else {
                Class childType = attr instanceof PluralAttribute ? ((PluralAttribute)attr).getElementType().getJavaType() : attr.getJavaType();
                CrudRepository childRepo = this.repositoryMetadata.repositoryFor(childType);
                if (null == childRepo) {
                    model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
                    return;
                }
                model.addAttribute(STATUS, (Object)HttpStatus.OK);
                TypeMetaCacheEntry childTypeMeta = this.typeMetaEntry(childRepo);
                Object child = typeMeta.entityMetadata.get(property, entity);
                if (null != child) {
                    Links links = new Links();
                    if (child instanceof Collection) {
                        for (Object o : (Collection)child) {
                            String childId = childTypeMeta.entityInfo.getId(o).toString();
                            URI uri = RepositoryRestController.buildUri(baseUri, repository, id, property, childId);
                            links.add(new SimpleLink(childType.getSimpleName(), uri));
                        }
                    } else if (child instanceof Map) {
                        for (Map.Entry entry : ((Map)child).entrySet()) {
                            String childId = childTypeMeta.entityInfo.getId(entry.getValue()).toString();
                            URI uri = RepositoryRestController.buildUri(baseUri, repository, id, property, childId);
                            Object oKey = entry.getKey();
                            String sKey = ClassUtils.isAssignable(oKey.getClass(), String.class) ? (String)oKey : (String)this.conversionService.convert(oKey, String.class);
                            links.add(new SimpleLink(sKey, uri));
                        }
                    } else {
                        String childId = childTypeMeta.entityInfo.getId(child).toString();
                        URI uri = RepositoryRestController.buildUri(baseUri, repository, id, property, childId);
                        links.add(new SimpleLink(property, uri));
                    }
                    model.addAttribute(RESOURCE, (Object)links);
                } else {
                    model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
                }
            }
        }
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.PUT, RequestMethod.POST}, consumes={"application/json", "text/uri-list"}, produces={"application/json", "text/uri-list"})
    public void updateLinks(final ServerHttpRequest request, UriComponentsBuilder uriBuilder, @PathVariable String repository, @PathVariable String id, final @PathVariable String property, final Model model) throws IOException {
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        final TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        final Object entity = repo.findOne(serId);
        if (null == entity) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
        } else {
            final Attribute attr = (Attribute)typeMeta.entityMetadata.linkedAttributes().get(property);
            if (null == attr) {
                model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            } else {
                final AtomicReference rel = new AtomicReference();
                Handler<Object, Void> entityHandler = new Handler<Object, Void>(){

                    public Void handle(Object childEntity) {
                        if (attr instanceof PluralAttribute) {
                            PluralAttribute plAttr = (PluralAttribute)attr;
                            switch (plAttr.getCollectionType()) {
                                case COLLECTION: 
                                case LIST: {
                                    ArrayList<Object> c = new ArrayList<Object>();
                                    Collection current = (Collection)typeMeta.entityMetadata.get(property, entity);
                                    if (request.getMethod() == HttpMethod.POST && null != current) {
                                        c.addAll(current);
                                    }
                                    c.add(childEntity);
                                    typeMeta.entityMetadata.set(property, c, entity);
                                    break;
                                }
                                case SET: {
                                    HashSet<Object> s = new HashSet<Object>();
                                    Set current = (Set)typeMeta.entityMetadata.get(property, entity);
                                    if (request.getMethod() == HttpMethod.POST && null != current) {
                                        s.addAll(current);
                                    }
                                    s.add(childEntity);
                                    typeMeta.entityMetadata.set(property, s, entity);
                                    break;
                                }
                                case MAP: {
                                    String key;
                                    HashMap m = new HashMap();
                                    Map current = (Map)typeMeta.entityMetadata.get(property, entity);
                                    if (request.getMethod() == HttpMethod.POST && null != current) {
                                        m.putAll(current);
                                    }
                                    if (null == (key = (String)rel.get())) {
                                        model.addAttribute(RepositoryRestController.STATUS, (Object)HttpStatus.NOT_ACCEPTABLE);
                                        return null;
                                    }
                                    m.put(rel.get(), childEntity);
                                    typeMeta.entityMetadata.set(property, m, entity);
                                }
                            }
                        } else if (attr instanceof SingularAttribute) {
                            typeMeta.entityMetadata.set(property, childEntity, entity);
                        }
                        return null;
                    }
                };
                MediaType incomingMediaType = request.getHeaders().getContentType();
                if (this.uriListMediaType.equals((Object)incomingMediaType)) {
                    String line;
                    BufferedReader in = new BufferedReader(new InputStreamReader(request.getBody()));
                    while (null != (line = in.readLine())) {
                        String sLinkUri = line.trim();
                        Object o = this.resolveTopLevelResource(baseUri, sLinkUri);
                        if (null == o) continue;
                        entityHandler.handle(o);
                    }
                } else if (this.jsonMediaType.equals((Object)incomingMediaType)) {
                    Map incoming = this.readIncoming((HttpInputMessage)request, incomingMediaType, Map.class);
                    for (Map link : (List)incoming.get(LINKS)) {
                        String sLinkUri = (String)link.get("href");
                        Object o = this.resolveTopLevelResource(baseUri, sLinkUri);
                        rel.set(link.get("rel"));
                        if (null == o) continue;
                        entityHandler.handle(o);
                    }
                }
                repo.save(entity);
                if (request.getMethod() == HttpMethod.PUT) {
                    model.addAttribute(STATUS, (Object)HttpStatus.NO_CONTENT);
                } else {
                    model.addAttribute(STATUS, (Object)HttpStatus.CREATED);
                }
            }
        }
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    public void clearLinks(@PathVariable String repository, @PathVariable String id, @PathVariable String property, Model model) {
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        Object entity = repo.findOne(serId);
        if (null == entity) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
        } else {
            Attribute attr = (Attribute)typeMeta.entityMetadata.linkedAttributes().get(property);
            if (null != attr) {
                typeMeta.entityMetadata.set(property, null, entity);
                repo.save(entity);
                model.addAttribute(STATUS, (Object)HttpStatus.NO_CONTENT);
            } else {
                model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            }
        }
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{childId}"}, method={RequestMethod.GET}, produces={"application/json"})
    public void childEntity(UriComponentsBuilder uriBuilder, @PathVariable String repository, @PathVariable String id, @PathVariable String property, @PathVariable String childId, Model model) {
        CrudRepository childRepo;
        Attribute attr;
        URI baseUri = uriBuilder.build().toUri();
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        Object entity = repo.findOne(serId);
        if (null != entity && null != (attr = (Attribute)typeMeta.entityMetadata.linkedAttributes().get(property)) && null != (childRepo = this.repositoryFromAttribute(attr))) {
            TypeMetaCacheEntry childTypeMeta = this.typeMetaEntry(childRepo);
            Serializable sChildId = this.stringToSerializable(childId, childTypeMeta.idType);
            Object childEntity = childRepo.findOne(sChildId);
            if (null != childEntity) {
                Map<String, Object> entityDto = this.extractPropertiesLinkAware(childEntity, childTypeMeta.entityMetadata, baseUri);
                URI selfUri = this.addSelfLink(baseUri, entityDto, repository, id);
                HttpHeaders headers = new HttpHeaders();
                headers.add("Content-Location", selfUri.toString());
                model.addAttribute(HEADERS, (Object)headers);
                model.addAttribute(STATUS, (Object)HttpStatus.OK);
                model.addAttribute(RESOURCE, entityDto);
                return;
            }
        }
        model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{childId}"}, method={RequestMethod.DELETE})
    public void deleteLink(@PathVariable String repository, @PathVariable String id, @PathVariable String property, @PathVariable String childId, Model model) {
        CrudRepository repo = this.repositoryMetadata.repositoryFor(repository);
        if (null == repo) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            return;
        }
        TypeMetaCacheEntry typeMeta = this.typeMetaEntry(repo);
        Serializable serId = this.stringToSerializable(id, typeMeta.idType);
        Object entity = repo.findOne(serId);
        if (null == entity) {
            model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
        } else {
            Attribute attr = (Attribute)typeMeta.entityMetadata.linkedAttributes().get(property);
            if (null == attr) {
                model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
            } else {
                CrudRepository childRepo = this.repositoryFromAttribute(attr);
                if (null == childRepo) {
                    model.addAttribute(STATUS, (Object)HttpStatus.NOT_FOUND);
                } else {
                    TypeMetaCacheEntry childTypeMeta = this.typeMetaEntry(childRepo);
                    Serializable sChildId = this.stringToSerializable(childId, childTypeMeta.idType);
                    Object childEntity = childRepo.findOne(sChildId);
                    if (null != childEntity) {
                        if (attr instanceof PluralAttribute) {
                            PluralAttribute plAttr = (PluralAttribute)attr;
                            switch (plAttr.getCollectionType()) {
                                case COLLECTION: 
                                case LIST: {
                                    Collection c = (Collection)typeMeta.entityMetadata.get(property, entity);
                                    if (null == c) break;
                                    c.remove(childEntity);
                                    break;
                                }
                                case SET: {
                                    Set s = (Set)typeMeta.entityMetadata.get(property, entity);
                                    if (null == s) break;
                                    s.remove(childEntity);
                                    break;
                                }
                                case MAP: {
                                    Object keyToRemove = null;
                                    Map m = (Map)typeMeta.entityMetadata.get(property, entity);
                                    if (null == m) break;
                                    for (Map.Entry entry : m.entrySet()) {
                                        Object val = entry.getValue();
                                        if (null == val || !val.equals(childEntity)) continue;
                                        keyToRemove = entry.getKey();
                                        break;
                                    }
                                    if (null == keyToRemove) break;
                                    m.remove(keyToRemove);
                                }
                            }
                        } else if (attr instanceof SingularAttribute) {
                            typeMeta.entityMetadata.set(property, childEntity, entity);
                        }
                        model.addAttribute(STATUS, (Object)HttpStatus.NO_CONTENT);
                    }
                }
            }
        }
    }

    @ExceptionHandler(value={OptimisticLockingFailureException.class})
    @ResponseBody
    public ResponseEntity handleLockingFailure(OptimisticLockingFailureException ex) throws IOException {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("message", ex.getMessage());
        return new ResponseEntity((Object)this.objectMapper.writeValueAsBytes(m), (MultiValueMap)headers, HttpStatus.BAD_REQUEST);
    }

    private static URI buildUri(URI baseUri, String ... pathSegments) {
        return UriComponentsBuilder.fromUri((URI)baseUri).pathSegment(pathSegments).build().toUri();
    }

    private TypeMetaCacheEntry typeMetaEntry(CrudRepository repo) {
        TypeMetaCacheEntry entry = this.typeMetaCache.get(repo);
        if (null == entry) {
            entry = new TypeMetaCacheEntry(repo);
            this.typeMetaCache.put(repo, entry);
        }
        return entry;
    }

    private CrudRepository repositoryFromAttribute(Attribute attr) {
        CrudRepository repo = attr instanceof PluralAttribute ? this.repositoryMetadata.repositoryFor(((PluralAttribute)attr).getElementType().getJavaType()) : this.repositoryMetadata.repositoryFor(attr.getJavaType());
        return repo;
    }

    private URI addSelfLink(URI baseUri, Map<String, Object> model, String ... pathComponents) {
        ArrayList<SimpleLink> links = (ArrayList<SimpleLink>)model.get(LINKS);
        if (null == links) {
            links = new ArrayList<SimpleLink>();
            model.put(LINKS, links);
        }
        URI selfUri = RepositoryRestController.buildUri(baseUri, pathComponents);
        links.add(new SimpleLink(SELF, selfUri));
        return selfUri;
    }

    private <V extends Serializable> V stringToSerializable(String s, Class<V> targetType) {
        if (ClassUtils.isAssignable(targetType, String.class)) {
            return (V)s;
        }
        return (V)((Serializable)this.conversionService.convert((Object)s, targetType));
    }

    private Object resolveTopLevelResource(URI baseUri, String uri) {
        URI href = URI.create(uri);
        URI relativeUri = baseUri.relativize(href);
        Stack uris = UriUtils.explode((URI)baseUri, (URI)relativeUri);
        if (uris.size() > 1) {
            String repoName = UriUtils.path((URI)((URI)uris.get(0)));
            String sId = UriUtils.path((URI)((URI)uris.get(1)));
            CrudRepository repo = this.repositoryMetadata.repositoryFor(repoName);
            if (null == repo) {
                return null;
            }
            EntityInformation entityInfo = this.repositoryMetadata.entityInfoFor(repo);
            if (null == entityInfo) {
                return null;
            }
            Class idType = entityInfo.getIdType();
            Object serId = this.stringToSerializable(sId, idType);
            return repo.findOne(serId);
        }
        return null;
    }

    private <V> V readIncoming(HttpInputMessage request, MediaType incomingMediaType, Class<V> targetType) throws IOException {
        for (HttpMessageConverter<?> converter : this.httpMessageConverters) {
            if (!converter.canRead(targetType, incomingMediaType)) continue;
            return (V)converter.read(targetType, request);
        }
        return null;
    }

    private Map<String, Object> extractPropertiesLinkAware(final Object entity, final JpaEntityMetadata entityMetadata, final URI baseUri) {
        final HashMap<String, Object> entityDto = new HashMap<String, Object>();
        entityMetadata.doWithEmbedded((Handler)new Handler<Attribute, Void>(){

            public Void handle(Attribute attr) {
                String name = attr.getName();
                Object val = entityMetadata.get(name, entity);
                if (null != val) {
                    entityDto.put(name, val);
                }
                return null;
            }
        });
        entityMetadata.doWithLinked((Handler)new Handler<Attribute, Void>(){

            public Void handle(Attribute attr) {
                String name = attr.getName();
                URI uri = UriComponentsBuilder.fromUri((URI)baseUri).pathSegment(new String[]{name}).build().toUri();
                SimpleLink l = new SimpleLink(name, uri);
                ArrayList<SimpleLink> links = (ArrayList<SimpleLink>)entityDto.get(RepositoryRestController.LINKS);
                if (null == links) {
                    links = new ArrayList<SimpleLink>();
                    entityDto.put(RepositoryRestController.LINKS, links);
                }
                links.add(l);
                return null;
            }
        });
        return entityDto;
    }

    private class TypeMetaCacheEntry {
        EntityInformation entityInfo;
        Class<?> domainClass;
        Class<? extends Serializable> idType;
        EntityType entityType;
        JpaEntityMetadata entityMetadata;

        private TypeMetaCacheEntry(CrudRepository repo) {
            this.entityInfo = RepositoryRestController.this.repositoryMetadata.entityInfoFor(repo);
            this.domainClass = this.entityInfo.getJavaType();
            this.idType = this.entityInfo.getIdType();
            this.entityType = RepositoryRestController.this.repositoryMetadata.entityTypeFor(this.domainClass);
            this.entityMetadata = RepositoryRestController.this.repositoryMetadata.entityMetadataFor(this.domainClass);
        }
    }
}

