/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.BaseUriAwareResource;
import org.springframework.data.rest.repository.PageableResources;
import org.springframework.data.rest.repository.PersistentEntityResource;
import org.springframework.data.rest.repository.context.AfterCreateEvent;
import org.springframework.data.rest.repository.context.AfterDeleteEvent;
import org.springframework.data.rest.repository.context.AfterSaveEvent;
import org.springframework.data.rest.repository.context.BeforeCreateEvent;
import org.springframework.data.rest.repository.context.BeforeDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeSaveEvent;
import org.springframework.data.rest.repository.invoke.RepositoryMethodInvoker;
import org.springframework.data.rest.repository.json.JsonSchema;
import org.springframework.data.rest.repository.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.repository.support.DomainObjectMerger;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/{repository}"})
public class RepositoryEntityController
extends AbstractRepositoryRestController {
    @Autowired
    private DomainObjectMerger domainObjectMerger;
    @Autowired
    private PersistentEntityToJsonSchemaConverter jsonSchemaConverter;

    public RepositoryEntityController(Repositories repositories, RepositoryRestConfiguration config, DomainClassConverter domainClassConverter, ConversionService conversionService, EntityLinks entityLinks) {
        super(repositories, config, domainClassConverter, conversionService, entityLinks);
    }

    @RequestMapping(value={"/schema"}, method={RequestMethod.GET}, produces={"application/schema+json"})
    @ResponseBody
    public JsonSchema schema(RepositoryRestRequest repoRequest) {
        return this.jsonSchemaConverter.convert(repoRequest.getPersistentEntity().getType());
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-verbose+json"})
    @ResponseBody
    public Resources<Resource<?>> listEntities(final RepositoryRestRequest repoRequest) throws ResourceNotFoundException {
        Iterable results;
        boolean hasSortParams;
        ArrayList<BaseUriAwareResource> resources = new ArrayList<BaseUriAwareResource>();
        ArrayList<Link> links = new ArrayList<Link>();
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (null == repoMethodInvoker) {
            throw new ResourceNotFoundException();
        }
        boolean hasPagingParams = null != repoRequest.getRequest().getParameter(this.config.getPageParamName());
        boolean bl = hasSortParams = null != repoRequest.getRequest().getParameter(this.config.getSortParamName());
        if (repoMethodInvoker.hasFindAllPageable() && hasPagingParams) {
            results = repoMethodInvoker.findAll((Pageable)new PageRequest(repoRequest.getPagingAndSorting().getPageNumber(), repoRequest.getPagingAndSorting().getPageSize(), repoRequest.getPagingAndSorting().getSort()));
        } else if (repoMethodInvoker.hasFindAllSorted() && hasSortParams) {
            results = repoMethodInvoker.findAll(repoRequest.getPagingAndSorting().getSort());
        } else if (repoMethodInvoker.hasFindAll()) {
            results = repoMethodInvoker.findAll();
        } else {
            throw new ResourceNotFoundException();
        }
        for (Object o : results) {
            BeanWrapper wrapper = BeanWrapper.create(o, (ConversionService)this.conversionService);
            Link selfLink = this.entityLinks.linkForSingleResource(repoRequest.getPersistentEntity().getType(), wrapper.getProperty(repoRequest.getPersistentEntity().getIdProperty())).withSelfRel();
            resources.add(new PersistentEntityResource(repoRequest.getPersistentEntity(), o, new Link[]{selfLink}).setBaseUri(repoRequest.getBaseUri()));
        }
        if (!repoMethodInvoker.getQueryMethods().isEmpty()) {
            ResourceMapping repoMapping = repoRequest.getRepositoryResourceMapping();
            links.add(new Link(UriUtils.buildUri((URI)repoRequest.getBaseUri(), (String[])new String[]{repoMapping.getPath(), "search"}).toString(), repoMapping.getRel() + ".search"));
        }
        if (hasPagingParams || hasSortParams) {
            PageRequest pr = new PageRequest(repoRequest.getPagingAndSorting().getPageNumber() + 1, repoRequest.getPagingAndSorting().getPageSize(), repoRequest.getPagingAndSorting().getSort()){

                public int getOffset() {
                    return super.getOffset() - repoRequest.getPagingAndSorting().getPageSize();
                }
            };
            return new PageableResources(resources, (Pageable)pr, links);
        }
        return new Resources(resources, links);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public Resources<Resource<?>> listEntitiesCompact(RepositoryRestRequest repoRequest) throws ResourceNotFoundException {
        boolean hasSortParams;
        Resources<Resource<?>> resources = this.listEntities(repoRequest);
        ArrayList<Link> links = new ArrayList<Link>(resources.getLinks());
        for (Resource resource : resources.getContent()) {
            PersistentEntityResource persistentEntityResource = (PersistentEntityResource)resource;
            links.add(this.resourceLink(repoRequest, (Resource)persistentEntityResource));
        }
        boolean hasPagingParams = null != repoRequest.getRequest().getParameter(this.config.getPageParamName());
        boolean bl = hasSortParams = null != repoRequest.getRequest().getParameter(this.config.getSortParamName());
        if (hasPagingParams || hasSortParams) {
            return new PageableResources(EMPTY_RESOURCE_LIST, (Pageable)repoRequest.getPagingAndSorting(), links);
        }
        return new Resources(EMPTY_RESOURCE_LIST, links);
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"}, produces={"application/json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<Resource<?>> createNewEntity(RepositoryRestRequest repoRequest, PersistentEntityResource<?> incoming) {
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (null == repoMethodInvoker || !repoMethodInvoker.hasSaveOne()) {
            throw new NoSuchMethodError();
        }
        this.applicationContext.publishEvent((ApplicationEvent)new BeforeCreateEvent(incoming.getContent()));
        Object obj = repoMethodInvoker.save(incoming.getContent());
        this.applicationContext.publishEvent((ApplicationEvent)new AfterCreateEvent(obj));
        BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
        Link selfLink = this.entityLinks.linkForSingleResource(repoRequest.getPersistentEntity().getType(), wrapper.getProperty(repoRequest.getPersistentEntity().getIdProperty())).withSelfRel();
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create(selfLink.getHref()));
        if (this.config.isReturnBodyOnCreate()) {
            return this.resourceResponse(headers, new PersistentEntityResource(repoRequest.getPersistentEntity(), obj, new Link[]{selfLink}).setBaseUri(repoRequest.getBaseUri()), HttpStatus.CREATED);
        }
        return this.resourceResponse(headers, null, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public Resource<?> getSingleEntity(RepositoryRestRequest repoRequest, @PathVariable String id) throws ResourceNotFoundException {
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (null == repoMethodInvoker || !repoMethodInvoker.hasFindOne()) {
            throw new ResourceNotFoundException();
        }
        Object domainObj = this.domainClassConverter.convert((Object)id, STRING_TYPE, TypeDescriptor.valueOf((Class)repoRequest.getPersistentEntity().getType()));
        if (null == domainObj) {
            throw new ResourceNotFoundException();
        }
        PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)repoRequest.getPersistentEntity(), (Object)domainObj, (URI)repoRequest.getBaseUri());
        BeanWrapper wrapper = BeanWrapper.create((Object)domainObj, (ConversionService)this.conversionService);
        Link selfLink = this.entityLinks.linkForSingleResource(repoRequest.getPersistentEntity().getType(), wrapper.getProperty(repoRequest.getPersistentEntity().getIdProperty())).withSelfRel();
        per.add(selfLink);
        return per;
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"}, produces={"application/json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<Resource<?>> updateEntity(RepositoryRestRequest repoRequest, PersistentEntityResource<?> incoming, @PathVariable String id) throws ResourceNotFoundException {
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (null == repoMethodInvoker || !repoMethodInvoker.hasSaveOne() || !repoMethodInvoker.hasFindOne()) {
            throw new NoSuchMethodError();
        }
        Object domainObj = this.domainClassConverter.convert((Object)id, STRING_TYPE, TypeDescriptor.valueOf((Class)repoRequest.getPersistentEntity().getType()));
        if (null == domainObj) {
            BeanWrapper incomingWrapper = BeanWrapper.create((Object)incoming.getContent(), (ConversionService)this.conversionService);
            PersistentProperty idProp = incoming.getPersistentEntity().getIdProperty();
            incomingWrapper.setProperty(idProp, this.conversionService.convert((Object)id, idProp.getType()));
            return this.createNewEntity(repoRequest, incoming);
        }
        this.domainObjectMerger.merge(incoming.getContent(), domainObj);
        this.applicationContext.publishEvent((ApplicationEvent)new BeforeSaveEvent(incoming.getContent()));
        Object obj = repoMethodInvoker.save(domainObj);
        this.applicationContext.publishEvent((ApplicationEvent)new AfterSaveEvent(obj));
        if (this.config.isReturnBodyOnUpdate()) {
            PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)repoRequest.getPersistentEntity(), (Object)obj, (URI)repoRequest.getBaseUri());
            BeanWrapper wrapper = BeanWrapper.create((Object)obj, (ConversionService)this.conversionService);
            Link selfLink = this.entityLinks.linkForSingleResource(repoRequest.getPersistentEntity().getType(), wrapper.getProperty(repoRequest.getPersistentEntity().getIdProperty())).withSelfRel();
            per.add(selfLink);
            return this.resourceResponse(null, per, HttpStatus.OK);
        }
        return this.resourceResponse(null, null, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<?> deleteEntity(RepositoryRestRequest repoRequest, @PathVariable String id) throws ResourceNotFoundException {
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (null == repoMethodInvoker || !repoMethodInvoker.hasFindOne() && !repoMethodInvoker.hasDeleteOne() && !repoMethodInvoker.hasDeleteOneById()) {
            throw new NoSuchMethodError();
        }
        Object domainObj = this.domainClassConverter.convert((Object)id, STRING_TYPE, TypeDescriptor.valueOf((Class)repoRequest.getPersistentEntity().getType()));
        if (null == domainObj) {
            throw new ResourceNotFoundException();
        }
        this.applicationContext.publishEvent((ApplicationEvent)new BeforeDeleteEvent(domainObj));
        if (repoMethodInvoker.hasDeleteOneById()) {
            Class idType = repoRequest.getPersistentEntity().getIdProperty().getType();
            Object idVal = this.conversionService.convert((Object)id, idType);
            repoMethodInvoker.delete((Serializable)idVal);
        } else if (repoMethodInvoker.hasDeleteOne()) {
            repoMethodInvoker.delete(domainObj);
        }
        this.applicationContext.publishEvent((ApplicationEvent)new AfterDeleteEvent(domainObj));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

