/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.data.rest.webmvc.RepositoryEntityController;
import org.springframework.data.rest.webmvc.RepositoryPropertyReferenceController;
import org.springframework.data.rest.webmvc.RepositorySearchController;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.http.MediaType;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class RepositoryRestHandlerMapping
extends RequestMappingHandlerMapping {
    @Autowired
    private Repositories repositories;
    @Autowired
    private RepositoryRestConfiguration config;
    @Autowired(required=false)
    private JpaHelper jpaHelper;

    public RepositoryRestHandlerMapping() {
        this.setOrder(Integer.MAX_VALUE);
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest origRequest) throws Exception {
        String acceptType = origRequest.getHeader("Accept");
        if (null == acceptType) {
            acceptType = this.config.getDefaultMediaType().toString();
        }
        List acceptHeaderTypes = MediaType.parseMediaTypes((String)acceptType);
        ArrayList<MediaType> acceptableTypes = new ArrayList<MediaType>();
        for (MediaType mt : acceptHeaderTypes) {
            if ("*".equals(mt.getType()) && "*".equals(mt.getSubtype()) || "application".equals(mt.getType()) && "*".equals(mt.getSubtype())) {
                mt = this.config.getDefaultMediaType();
            }
            if (acceptableTypes.contains(mt)) continue;
            acceptableTypes.add(mt);
        }
        acceptType = acceptableTypes.size() > 1 ? StringUtils.collectionToDelimitedString(acceptableTypes, (String)",") : (acceptableTypes.size() == 1 ? ((MediaType)acceptableTypes.get(0)).toString() : this.config.getDefaultMediaType().toString());
        DefaultAcceptTypeHttpServletRequest request = new DefaultAcceptTypeHttpServletRequest(origRequest, acceptType);
        if (acceptType.contains("javascript")) {
            if (null != request.getParameter(this.config.getJsonpParamName()) || null != request.getParameter(this.config.getJsonpOnErrParamName())) {
                return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)request);
            }
            return null;
        }
        String requestUri = lookupPath;
        if (requestUri.startsWith("/")) {
            requestUri = requestUri.substring(1);
        }
        if (!StringUtils.hasText((String)requestUri)) {
            return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)request);
        }
        String[] parts = requestUri.split("/");
        if (parts.length == 0) {
            return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)request);
        }
        for (Class domainType : this.repositories) {
            RepositoryInformation repoInfo = this.repositories.getRepositoryInformationFor(domainType);
            ResourceMapping mapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)this.config, (RepositoryInformation)repoInfo);
            if (!mapping.getPath().equals(parts[0]) || !mapping.isExported()) continue;
            return super.lookupHandlerMethod(lookupPath, (HttpServletRequest)request);
        }
        return null;
    }

    protected boolean isHandler(Class<?> beanType) {
        return RepositoryController.class.isAssignableFrom(beanType) || RepositoryEntityController.class.isAssignableFrom(beanType) || RepositoryPropertyReferenceController.class.isAssignableFrom(beanType) || RepositorySearchController.class.isAssignableFrom(beanType);
    }

    protected void extendInterceptors(List<Object> interceptors) {
        if (null != this.jpaHelper) {
            for (Object o : this.jpaHelper.getInterceptors()) {
                interceptors.add(o);
            }
        }
    }

    private static class DefaultAcceptTypeHttpServletRequest
    extends HttpServletRequestWrapper {
        private final String defaultAcceptType;

        private DefaultAcceptTypeHttpServletRequest(HttpServletRequest request, String defaultAcceptType) {
            super(request);
            this.defaultAcceptType = defaultAcceptType;
        }

        public String getHeader(String name) {
            if ("accept".equals(name.toLowerCase())) {
                return this.defaultAcceptType;
            }
            return super.getHeader(name);
        }
    }
}

