/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.data.domain.Page;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.PagingAndSorting;
import org.springframework.data.rest.repository.invoke.RepositoryMethodInvoker;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.hateoas.Link;
import org.springframework.web.util.UriComponentsBuilder;

class RepositoryRestRequest {
    private final RepositoryRestConfiguration config;
    private final HttpServletRequest request;
    private final PagingAndSorting pagingAndSorting;
    private final URI baseUri;
    private final RepositoryInformation repoInfo;
    private final ResourceMapping repoMapping;
    private final Link repoLink;
    private final Object repository;
    private final RepositoryMethodInvoker repoMethodInvoker;
    private final PersistentEntity persistentEntity;
    private final ResourceMapping entityMapping;

    public RepositoryRestRequest(RepositoryRestConfiguration config, Repositories repositories, HttpServletRequest request, PagingAndSorting pagingAndSorting, URI baseUri, RepositoryInformation repoInfo) {
        this.config = config;
        this.request = request;
        this.pagingAndSorting = pagingAndSorting;
        this.baseUri = baseUri;
        this.repoInfo = repoInfo;
        this.repoMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)config, (RepositoryInformation)repoInfo);
        if (null == this.repoMapping || !this.repoMapping.isExported()) {
            this.repoLink = null;
            this.repository = null;
            this.repoMethodInvoker = null;
            this.persistentEntity = null;
            this.entityMapping = null;
        } else {
            this.repoLink = new Link(UriUtils.buildUri((URI)baseUri, (String[])new String[]{this.repoMapping.getPath()}).toString(), this.repoMapping.getRel());
            this.repository = repositories.getRepositoryFor(repoInfo.getDomainType());
            this.persistentEntity = repositories.getPersistentEntity(repoInfo.getDomainType());
            this.repoMethodInvoker = new RepositoryMethodInvoker(this.repository, repoInfo, this.persistentEntity);
            this.entityMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)config, (PersistentEntity)this.persistentEntity);
        }
    }

    HttpServletRequest getRequest() {
        return this.request;
    }

    PagingAndSorting getPagingAndSorting() {
        return this.pagingAndSorting;
    }

    URI getBaseUri() {
        return this.baseUri;
    }

    RepositoryInformation getRepositoryInformation() {
        return this.repoInfo;
    }

    ResourceMapping getRepositoryResourceMapping() {
        return this.repoMapping;
    }

    Link getRepositoryLink() {
        return this.repoLink;
    }

    Object getRepository() {
        return this.repository;
    }

    RepositoryMethodInvoker getRepositoryMethodInvoker() {
        return this.repoMethodInvoker;
    }

    PersistentEntity getPersistentEntity() {
        return this.persistentEntity;
    }

    ResourceMapping getPersistentEntityResourceMapping() {
        return this.entityMapping;
    }

    void addNextLink(Page page, List<Link> links) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.baseUri);
        this.addQueryParameters(this.request, builder);
        builder.queryParam(this.config.getPageParamName(), new Object[]{page.getNumber() + 1}).queryParam(this.config.getLimitParamName(), new Object[]{this.pagingAndSorting.getPageSize()});
        links.add(new Link(builder.build().toString(), "page.next"));
    }

    void addPrevLink(Page page, List<Link> links) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromUri((URI)this.baseUri);
        this.addQueryParameters(this.request, builder);
        builder.queryParam(this.config.getPageParamName(), new Object[]{page.getNumber() - 1}).queryParam(this.config.getLimitParamName(), new Object[]{this.pagingAndSorting.getPageSize()});
        links.add(new Link(builder.build().toString(), "page.previous"));
    }

    private void addQueryParameters(HttpServletRequest request, UriComponentsBuilder builder) {
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String value = request.getParameter(name);
            if (name.equals(this.config.getPageParamName()) || name.equals(this.config.getLimitParamName())) continue;
            builder.queryParam(name, new Object[]{value});
        }
    }
}

