/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.support.DomainObjectMerger;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositoryEntityController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}";
    private final EntityLinks entityLinks;
    private final PersistentEntityResourceAssembler<Object> perAssembler;
    private final RepositoryRestConfiguration config;
    private final DomainClassConverter<?> converter;
    private final ConversionService conversionService;
    private final DomainObjectMerger domainObjectMerger;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryEntityController(Repositories repositories, RepositoryRestConfiguration config, EntityLinks entityLinks, PagedResourcesAssembler<Object> assembler, PersistentEntityResourceAssembler<Object> perAssembler, DomainClassConverter<?> converter, @Qualifier(value="defaultConversionService") ConversionService conversionService, DomainObjectMerger domainObjectMerger) {
        super(assembler, perAssembler);
        this.entityLinks = entityLinks;
        this.perAssembler = perAssembler;
        this.config = config;
        this.converter = converter;
        this.conversionService = conversionService;
        this.domainObjectMerger = domainObjectMerger;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET})
    public Resources<?> listEntities(RepositoryRestRequest request, Pageable pageable, Sort sort) throws ResourceNotFoundException {
        ArrayList<Link> links = new ArrayList<Link>();
        RepositoryInvoker repoMethodInvoker = request.getRepositoryInvoker();
        if (null == repoMethodInvoker) {
            throw new ResourceNotFoundException();
        }
        Iterable results = pageable != null ? repoMethodInvoker.invokeFindAll(pageable) : repoMethodInvoker.invokeFindAll(sort);
        ResourceMetadata metadata = request.getResourceMetadata();
        SearchResourceMappings searchMappings = metadata.getSearchResourceMappings();
        if (searchMappings.isExported()) {
            links.add(this.entityLinks.linkFor(metadata.getDomainType()).slash((Object)searchMappings.getPath()).withRel(searchMappings.getRel()));
        }
        Resources resources = this.resultToResources(results);
        resources.add(links);
        return resources;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public Resources<?> listEntitiesCompact(RepositoryRestRequest repoRequest, Pageable pageable, Sort sort) {
        Resources<?> resources = this.listEntities(repoRequest, pageable, sort);
        ArrayList<Link> links = new ArrayList<Link>(resources.getLinks());
        for (Resource resource : resources.getContent()) {
            PersistentEntityResource persistentEntityResource = (PersistentEntityResource)resource;
            links.add(this.resourceLink(repoRequest, persistentEntityResource));
        }
        if (resources instanceof PagedResources) {
            return new PagedResources(Collections.emptyList(), ((PagedResources)resources).getMetadata(), links);
        }
        return new Resources(Collections.emptyList(), links);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public ResponseEntity<ResourceSupport> createNewEntity(RepositoryRestRequest repoRequest, PersistentEntityResource<?> incoming) {
        RepositoryInvoker invoker = repoRequest.getRepositoryInvoker();
        if (!invoker.exposesSave()) {
            throw new NoSuchMethodError();
        }
        this.publisher.publishEvent((ApplicationEvent)new BeforeCreateEvent(incoming.getContent()));
        Object obj = invoker.invokeSave(incoming.getContent());
        this.publisher.publishEvent((ApplicationEvent)new AfterCreateEvent(obj));
        Link selfLink = this.perAssembler.getSelfLinkFor(obj);
        HttpHeaders headers = new HttpHeaders();
        headers.setLocation(URI.create(selfLink.getHref()));
        PersistentEntityResource<Object> resource = this.config.isReturnBodyOnCreate() ? this.perAssembler.toResource(obj) : null;
        return ControllerUtils.toResponseEntity(HttpStatus.CREATED, headers, resource);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Resource<?>> getSingleEntity(RepositoryRestRequest repoRequest, @PathVariable String id) {
        RepositoryInvoker repoMethodInvoker = repoRequest.getRepositoryInvoker();
        if (!repoMethodInvoker.exposesFindOne()) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        Object domainObj = repoMethodInvoker.invokeFindOne((Serializable)((Object)id));
        if (domainObj == null) {
            return new ResponseEntity(HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity(this.perAssembler.toResource(domainObj), HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PUT}, consumes={"application/json"})
    public ResponseEntity<? extends ResourceSupport> updateEntity(RepositoryRestRequest request, PersistentEntityResource<Object> incoming, @PathVariable String id) {
        RepositoryInvoker invoker = request.getRepositoryInvoker();
        if (!invoker.exposesSave() || !invoker.exposesFindOne()) {
            return new ResponseEntity(HttpStatus.METHOD_NOT_ALLOWED);
        }
        Object domainObj = this.converter.convert((Object)id, ControllerUtils.STRING_TYPE, TypeDescriptor.valueOf((Class)request.getPersistentEntity().getType()));
        if (null == domainObj) {
            BeanWrapper incomingWrapper = BeanWrapper.create((Object)incoming.getContent(), (ConversionService)this.conversionService);
            PersistentProperty idProp = incoming.getPersistentEntity().getIdProperty();
            incomingWrapper.setProperty(idProp, this.conversionService.convert((Object)id, idProp.getType()));
            return this.createNewEntity(request, incoming);
        }
        this.domainObjectMerger.merge(incoming.getContent(), domainObj);
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(incoming.getContent()));
        Object obj = invoker.invokeSave(domainObj);
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(obj));
        if (this.config.isReturnBodyOnUpdate()) {
            return ControllerUtils.toResponseEntity(HttpStatus.OK, null, this.perAssembler.toResource(obj));
        }
        return ControllerUtils.toResponseEntity(HttpStatus.NO_CONTENT, null, null);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteEntity(RepositoryRestRequest repoRequest, @PathVariable String id) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        RepositoryInvoker invoker = repoRequest.getRepositoryInvoker();
        if (!invoker.exposesDelete() || !invoker.exposesFindOne()) {
            throw new HttpRequestMethodNotSupportedException(RequestMethod.DELETE.toString());
        }
        Object domainObj = invoker.invokeFindOne((Serializable)((Object)id));
        this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(domainObj));
        invoker.invokeDelete((Serializable)((Object)id));
        this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(domainObj));
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }
}

