/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.core.MethodParameter;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.invoke.RepositoryInvokerFactory;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.RepositoryRestRequestHandlerMethodArgumentResolver;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class RepositoryInvokerHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private final RepositoryRestRequestHandlerMethodArgumentResolver requestResolver;
    private final RepositoryInvokerFactory invokerFactory;

    private RepositoryInvokerHandlerMethodArgumentResolver(RepositoryRestRequestHandlerMethodArgumentResolver requestResolver, RepositoryInvokerFactory invokerFactory) {
        this.requestResolver = requestResolver;
        this.invokerFactory = invokerFactory;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return RepositoryInvoker.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RepositoryRestRequest request = this.requestResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        return this.invokerFactory.getInvokerFor(request.getPersistentEntity().getType());
    }
}

