/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.event.AfterLinkDeleteEvent;
import org.springframework.data.rest.core.event.AfterLinkSaveEvent;
import org.springframework.data.rest.core.event.BeforeLinkDeleteEvent;
import org.springframework.data.rest.core.event.BeforeLinkSaveEvent;
import org.springframework.data.rest.core.invoke.RepositoryInvoker;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.util.Function;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.UriComponentsBuilder;

@RepositoryRestController
public class RepositoryPropertyReferenceController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}/{id}/{property}";
    private final Repositories repositories;
    private final PersistentEntityResourceAssembler<Object> perAssembler;
    private final DomainClassConverter<?> converter;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryPropertyReferenceController(Repositories repositories, DomainClassConverter<?> domainClassConverter, PagedResourcesAssembler<Object> assembler, PersistentEntityResourceAssembler<Object> perAssembler) {
        super(assembler, perAssembler);
        this.repositories = repositories;
        this.perAssembler = perAssembler;
        this.converter = domainClassConverter;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET})
    public ResponseEntity<ResourceSupport> followPropertyReference(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property) throws ResourceNotFoundException, NoSuchMethodException {
        final HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    throw new ResourceNotFoundException();
                }
                if (prop.property.isCollectionLike()) {
                    ArrayList resources = new ArrayList();
                    for (Object obj : (Iterable)prop.propertyValue) {
                        resources.add(RepositoryPropertyReferenceController.this.perAssembler.toResource(obj));
                    }
                    return new Resources(resources, new Link[0]);
                }
                if (prop.property.isMap()) {
                    HashMap resources = new HashMap();
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        resources.put(entry.getKey(), RepositoryPropertyReferenceController.this.perAssembler.toResource(entry.getValue()));
                    }
                    return new Resource(resources, new Link[0]);
                }
                PersistentEntityResource<Object> resource = RepositoryPropertyReferenceController.this.perAssembler.toResource(prop.propertyValue);
                headers.set("Content-Location", resource.getId().getHref());
                return resource;
            }
        };
        ResourceSupport responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, responseResource);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.DELETE})
    public ResponseEntity<? extends ResourceSupport> deletePropertyReference(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property) throws ResourceNotFoundException, NoSuchMethodException, HttpRequestMethodNotSupportedException {
        block3: {
            final RepositoryInvoker repoMethodInvoker = repoRequest.getRepositoryInvoker();
            if (!repoMethodInvoker.exposesDelete()) {
                return new ResponseEntity(HttpStatus.METHOD_NOT_ALLOWED);
            }
            Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

                public Resource<?> apply(ReferencedProperty prop) {
                    if (null == prop.propertyValue) {
                        return null;
                    }
                    if (prop.property.isCollectionLike()) {
                        throw new IllegalArgumentException((Throwable)new HttpRequestMethodNotSupportedException("DELETE"));
                    }
                    if (prop.property.isMap()) {
                        throw new IllegalArgumentException((Throwable)new HttpRequestMethodNotSupportedException("DELETE"));
                    }
                    prop.wrapper.setProperty(prop.property, null);
                    RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.wrapper.getBean(), prop.propertyValue));
                    Object result = repoMethodInvoker.invokeSave(prop.wrapper.getBean());
                    RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                    return null;
                }
            };
            try {
                this.doWithReferencedProperty(repoRequest, id, property, handler);
            }
            catch (IllegalArgumentException iae) {
                if (!(iae.getCause() instanceof HttpRequestMethodNotSupportedException)) break block3;
                throw (HttpRequestMethodNotSupportedException)iae.getCause();
            }
        }
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-verbose+json", "application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<ResourceSupport> followPropertyReference(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property, final @PathVariable String propertyId) throws ResourceNotFoundException, NoSuchMethodException {
        final HttpHeaders headers = new HttpHeaders();
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    throw new ResourceNotFoundException();
                }
                if (prop.property.isCollectionLike()) {
                    for (Object obj : (Iterable)prop.propertyValue) {
                        BeanWrapper propValWrapper = BeanWrapper.create(obj, null);
                        String sId = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(sId)) continue;
                        PersistentEntityResource resource = RepositoryPropertyReferenceController.this.perAssembler.toResource(obj);
                        headers.set("Content-Location", resource.getId().getHref());
                        return resource;
                    }
                } else if (prop.property.isMap()) {
                    for (Map.Entry entry : ((Map)prop.propertyValue).entrySet()) {
                        BeanWrapper propValWrapper = BeanWrapper.create(entry.getValue(), null);
                        String sId = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(sId)) continue;
                        PersistentEntityResource resource = RepositoryPropertyReferenceController.this.perAssembler.toResource(entry.getValue());
                        headers.set("Content-Location", resource.getId().getHref());
                        return resource;
                    }
                } else {
                    return new Resource(prop.propertyValue, new Link[0]);
                }
                throw new IllegalArgumentException(new ResourceNotFoundException());
            }
        };
        ResourceSupport responseResource = this.doWithReferencedProperty(repoRequest, id, property, handler);
        return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, responseResource);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public ResponseEntity<ResourceSupport> followPropertyReferenceCompact(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property) throws ResourceNotFoundException, NoSuchMethodException {
        ResponseEntity<ResourceSupport> response = this.followPropertyReference(repoRequest, id, property);
        if (response.getStatusCode() != HttpStatus.OK) {
            return response;
        }
        ResourceMetadata repoMapping = repoRequest.getResourceMetadata();
        PersistentProperty persistentProp = repoRequest.getPersistentEntity().getPersistentProperty(property);
        ResourceMapping propertyMapping = repoMapping.getMappingFor(persistentProp);
        ResourceSupport resource = (ResourceSupport)response.getBody();
        ArrayList<Link> links = new ArrayList<Link>();
        ControllerLinkBuilder linkBuilder = ControllerLinkBuilder.linkTo(((RepositoryPropertyReferenceController)ControllerLinkBuilder.methodOn(RepositoryPropertyReferenceController.class, (Object[])new Object[0])).followPropertyReference(repoRequest, id, property));
        if (resource instanceof Resource) {
            Object content = ((Resource)resource).getContent();
            if (content instanceof Iterable) {
                for (Resource res : (Iterable)content) {
                    links.add(linkBuilder.withRel(propertyMapping.getRel()));
                }
            } else if (content instanceof Map) {
                Map map = (Map)content;
                for (Map.Entry entry : map.entrySet()) {
                    Link l = new Link(((Resource)entry.getValue()).getLink("self").getHref(), entry.getKey().toString());
                    links.add(l);
                }
            }
        } else {
            links.add(linkBuilder.withRel(propertyMapping.getRel()));
        }
        return ControllerUtils.toResponseEntity(HttpStatus.OK, null, new Resource(ControllerUtils.EMPTY_RESOURCE_LIST, links));
    }

    @RequestMapping(value={"/{repository}/{id}/{property}"}, method={RequestMethod.POST, RequestMethod.PUT}, consumes={"application/json", "application/x-spring-data-compact+json", "text/uri-list"})
    @ResponseBody
    public ResponseEntity<? extends ResourceSupport> createPropertyReference(final RepositoryRestRequest repoRequest, final @RequestBody Resources<Object> incoming, @PathVariable String id, @PathVariable String property, UriComponentsBuilder builder) throws NoSuchMethodException {
        final RepositoryInvoker invoker = repoRequest.getRepositoryInvoker();
        if (!invoker.exposesSave()) {
            return new ResponseEntity(HttpStatus.METHOD_NOT_ALLOWED);
        }
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                Class propertyType = prop.property.getType();
                if (prop.property.isCollectionLike()) {
                    Collection coll = CollectionFactory.createCollection((Class)propertyType, (int)0);
                    if (HttpMethod.POST.equals((Object)repoRequest.getRequestMethod())) {
                        coll = (Collection)prop.propertyValue;
                    }
                    for (Link l : incoming.getLinks()) {
                        Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l.getHref());
                        coll.add(propVal);
                    }
                    prop.wrapper.setProperty(prop.property, (Object)coll);
                } else if (prop.property.isMap()) {
                    Map m = CollectionFactory.createMap((Class)propertyType, (int)0);
                    if (HttpMethod.POST.equals((Object)repoRequest.getRequestMethod())) {
                        m = (Map)prop.propertyValue;
                    }
                    for (Link l : incoming.getLinks()) {
                        Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, l.getHref());
                        m.put(l.getRel(), propVal);
                    }
                    prop.wrapper.setProperty(prop.property, (Object)m);
                } else {
                    if (HttpMethod.POST.equals((Object)repoRequest.getRequestMethod())) {
                        throw new IllegalStateException("Cannot POST a reference to this singular property since the property type is not a List or a Map.");
                    }
                    if (incoming.getLinks().size() != 1) {
                        throw new IllegalArgumentException("Must send only 1 link to update a property reference that isn't a List or a Map.");
                    }
                    Object propVal = RepositoryPropertyReferenceController.this.loadPropertyValue(prop.propertyType, ((Link)incoming.getLinks().get(0)).getHref());
                    prop.wrapper.setProperty(prop.property, propVal);
                }
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkSaveEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = invoker.invokeSave(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkSaveEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Location", builder.build().toUriString());
        return ControllerUtils.toEmptyResponse(HttpStatus.CREATED, headers);
    }

    @RequestMapping(value={"/{repository}/{id}/{property}/{propertyId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public ResponseEntity<ResourceSupport> deletePropertyReferenceId(RepositoryRestRequest repoRequest, @PathVariable String id, @PathVariable String property, final @PathVariable String propertyId) throws NoSuchMethodException {
        final RepositoryInvoker invoker = repoRequest.getRepositoryInvoker();
        if (!invoker.exposesDelete()) {
            throw new NoSuchMethodError();
        }
        Function<ReferencedProperty, ResourceSupport> handler = new Function<ReferencedProperty, ResourceSupport>(){

            public ResourceSupport apply(ReferencedProperty prop) {
                if (null == prop.propertyValue) {
                    return null;
                }
                if (prop.property.isCollectionLike()) {
                    Collection coll = (Collection)prop.propertyValue;
                    Iterator itr = coll.iterator();
                    while (itr.hasNext()) {
                        Object obj = itr.next();
                        BeanWrapper propValWrapper = BeanWrapper.create(obj, null);
                        String s = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(s)) continue;
                        itr.remove();
                    }
                } else if (prop.property.isMap()) {
                    Map m = (Map)prop.propertyValue;
                    Iterator itr = m.keySet().iterator();
                    while (itr.hasNext()) {
                        Object key = itr.next();
                        BeanWrapper propValWrapper = BeanWrapper.create(m.get(key), null);
                        String s = propValWrapper.getProperty(prop.entity.getIdProperty()).toString();
                        if (!propertyId.equals(s)) continue;
                        itr.remove();
                    }
                } else {
                    prop.wrapper.setProperty(prop.property, null);
                }
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new BeforeLinkDeleteEvent(prop.wrapper.getBean(), prop.propertyValue));
                Object result = invoker.invokeSave(prop.wrapper.getBean());
                RepositoryPropertyReferenceController.this.publisher.publishEvent((ApplicationEvent)new AfterLinkDeleteEvent(result, prop.propertyValue));
                return null;
            }
        };
        this.doWithReferencedProperty(repoRequest, id, property, handler);
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT);
    }

    private Object loadPropertyValue(Class<?> type, String href) {
        String id = href.substring(href.lastIndexOf(47) + 1);
        return this.converter.convert((Object)id, ControllerUtils.STRING_TYPE, TypeDescriptor.valueOf(type));
    }

    private ResourceSupport doWithReferencedProperty(RepositoryRestRequest repoRequest, String id, String propertyPath, Function<ReferencedProperty, ResourceSupport> handler) throws NoSuchMethodException {
        RepositoryInvoker invoker = repoRequest.getRepositoryInvoker();
        if (!invoker.exposesFindOne()) {
            throw new NoSuchMethodException();
        }
        Object domainObj = invoker.invokeFindOne((Serializable)((Object)id));
        if (null == domainObj) {
            throw new ResourceNotFoundException();
        }
        PersistentProperty prop = repoRequest.getPersistentEntity().getPersistentProperty(propertyPath);
        if (null == prop) {
            throw new ResourceNotFoundException();
        }
        BeanWrapper wrapper = BeanWrapper.create((Object)domainObj, null);
        Object propVal = wrapper.getProperty(prop);
        return (ResourceSupport)handler.apply((Object)new ReferencedProperty(prop, propVal, wrapper));
    }

    private class ReferencedProperty {
        final PersistentEntity<?, ?> entity;
        final PersistentProperty<?> property;
        final Class<?> propertyType;
        final Object propertyValue;
        final BeanWrapper<?, ?> wrapper;

        private ReferencedProperty(PersistentProperty<?> property, Object propertyValue, BeanWrapper<?, ?> wrapper) {
            this.property = property;
            this.propertyValue = propertyValue;
            this.wrapper = wrapper;
            this.propertyType = property.getActualType();
            this.entity = RepositoryPropertyReferenceController.this.repositories.getPersistentEntity(this.propertyType);
        }
    }
}

