/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositorySchemaController {
    private static final String BASE_MAPPING = "/{repository}";
    private final PersistentEntityToJsonSchemaConverter jsonSchemaConverter;

    @Autowired
    public RepositorySchemaController(PersistentEntityToJsonSchemaConverter jsonSchemaConverter) {
        Assert.notNull((Object)jsonSchemaConverter, (String)"PersistentEntityToJsonSchemaConverter must not be null!");
        this.jsonSchemaConverter = jsonSchemaConverter;
    }

    @RequestMapping(value={"/{repository}/schema"}, method={RequestMethod.GET}, produces={"application/schema+json"})
    @ResponseBody
    public JsonSchema schema(RepositoryRestRequest repoRequest) {
        return this.jsonSchemaConverter.convert(repoRequest.getPersistentEntity().getType());
    }
}

