/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.util.Assert;

public class PersistentEntityResourceAssembler
implements ResourceAssembler<Object, PersistentEntityResource<Object>> {
    private final Repositories repositories;
    private final EntityLinks entityLinks;
    private final Projector projector;

    public PersistentEntityResourceAssembler(Repositories repositories, EntityLinks entityLinks, Projector projector) {
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull((Object)projector, (String)"PersistentEntityProjector must not be be null!");
        this.repositories = repositories;
        this.entityLinks = entityLinks;
        this.projector = projector;
    }

    public PersistentEntityResource<Object> toResource(Object instance) {
        PersistentEntity entity = this.repositories.getPersistentEntity(instance.getClass());
        return PersistentEntityResource.wrap(entity, this.projector.project(instance), this.getSelfLinkFor(instance));
    }

    public Link getSelfLinkFor(Object instance) {
        Assert.notNull((Object)instance, (String)"Domain object must not be null!");
        Class<?> instanceType = instance.getClass();
        PersistentEntity entity = this.repositories.getPersistentEntity(instanceType);
        if (entity == null) {
            throw new IllegalArgumentException(String.format("Cannot create self link for %s! No persistent entity found!", instanceType));
        }
        BeanWrapper wrapper = BeanWrapper.create((Object)instance, null);
        Object id = wrapper.getProperty(entity.getIdProperty());
        Link resourceLink = this.entityLinks.linkToSingleResource(entity.getType(), id);
        return new Link(resourceLink.getHref(), "self");
    }
}

