/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.util.ClassUtils;

public class PersistentEntityResourceProcessor
implements ResourceProcessor<PersistentEntityResource<?>> {
    private final List<DomainTypeResourceProcessor> resourceProcessors = new ArrayList<DomainTypeResourceProcessor>();

    @Autowired
    public PersistentEntityResourceProcessor(Repositories repositories, List<ResourceProcessor<Resource<?>>> resourceProcessors) {
        if (null != resourceProcessors) {
            for (ResourceProcessor<Resource<?>> rp : resourceProcessors) {
                ClassTypeInformation typeInfo = ClassTypeInformation.from(rp.getClass());
                TypeInformation domainType = (TypeInformation)typeInfo.getTypeArguments().get(0);
                if (null == repositories.getPersistentEntity(domainType.getType())) continue;
                this.resourceProcessors.add(new DomainTypeResourceProcessor(domainType.getType(), rp));
            }
        }
    }

    public PersistentEntityResource<?> process(PersistentEntityResource<?> resource) {
        Object content = resource.getContent();
        if (null == content) {
            return resource;
        }
        Class<?> domainType = content.getClass();
        for (DomainTypeResourceProcessor rp : this.resourceProcessors) {
            if (!ClassUtils.isAssignable(domainType, rp.domainType)) continue;
            rp.resourceProcessor.process(resource);
        }
        return resource;
    }

    private static class DomainTypeResourceProcessor {
        final Class<?> domainType;
        final ResourceProcessor<Resource<?>> resourceProcessor;

        private DomainTypeResourceProcessor(Class<?> domainType, ResourceProcessor<Resource<?>> resourceProcessor) {
            this.domainType = domainType;
            this.resourceProcessor = resourceProcessor;
        }
    }
}

