/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import java.util.HashSet;
import java.util.Set;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.SimpleAssociationHandler;
import org.springframework.data.mapping.SimplePropertyHandler;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.rest.core.Path;
import org.springframework.data.rest.core.mapping.ResourceDescription;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.json.JsonSchema;
import org.springframework.data.rest.webmvc.mapping.AssociationLinks;
import org.springframework.data.rest.webmvc.mapping.LinkCollectingAssociationHandler;
import org.springframework.data.util.TypeInformation;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityToJsonSchemaConverter
implements ConditionalGenericConverter {
    private static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor SCHEMA_TYPE = TypeDescriptor.valueOf(JsonSchema.class);
    private final Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();
    private final ResourceMappings mappings;
    private final PersistentEntities repositories;
    private final MessageSourceAccessor accessor;
    private final EntityLinks entityLinks;

    public PersistentEntityToJsonSchemaConverter(PersistentEntities entities, ResourceMappings mappings, MessageSourceAccessor accessor, EntityLinks entityLinks) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        Assert.notNull((Object)accessor, (String)"MessageSourceAccessor must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        this.repositories = entities;
        this.mappings = mappings;
        this.accessor = accessor;
        this.entityLinks = entityLinks;
        for (TypeInformation domainType : entities.getManagedTypes()) {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(domainType.getType(), JsonSchema.class));
        }
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Class.class.isAssignableFrom(sourceType.getType()) && JsonSchema.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public JsonSchema convert(Class<?> domainType) {
        return (JsonSchema)((Object)this.convert(domainType, STRING_TYPE, SCHEMA_TYPE));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity((Class)source);
        final ResourceMetadata metadata = this.mappings.getMappingFor(persistentEntity.getType());
        final JsonSchema jsonSchema = new JsonSchema(persistentEntity.getName(), this.accessor.getMessage((MessageSourceResolvable)metadata.getItemResourceDescription()));
        persistentEntity.doWithProperties(new SimplePropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty<?> persistentProperty) {
                Class propertyType = persistentProperty.getType();
                String type = StringUtils.uncapitalize((String)propertyType.getSimpleName());
                ResourceMapping propertyMapping = metadata.getMappingFor(persistentProperty);
                ResourceDescription description = propertyMapping.getDescription();
                String message = PersistentEntityToJsonSchemaConverter.this.accessor.getMessage((MessageSourceResolvable)description);
                JsonSchema.Property property = persistentProperty.isCollectionLike() ? new JsonSchema.ArrayProperty("array", message, false) : new JsonSchema.Property(type, message, false);
                jsonSchema.addProperty(persistentProperty.getName(), property);
            }
        });
        Link link = this.entityLinks.linkToCollectionResource(persistentEntity.getType()).expand(new Object[0]);
        LinkCollectingAssociationHandler associationHandler = new LinkCollectingAssociationHandler(this.repositories, new Path(link.getHref()), new AssociationLinks(this.mappings));
        persistentEntity.doWithAssociations((SimpleAssociationHandler)associationHandler);
        jsonSchema.add(associationHandler.getLinks());
        return jsonSchema;
    }
}

