/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryLinksResource;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
public class RepositoryController
extends AbstractRepositoryRestController {
    private final Repositories repositories;
    private final EntityLinks entityLinks;
    private final ResourceMappings mappings;

    @Autowired
    public RepositoryController(PagedResourcesAssembler<Object> assembler, Repositories repositories, EntityLinks entityLinks, ResourceMappings mappings) {
        super(assembler);
        this.repositories = repositories;
        this.entityLinks = entityLinks;
        this.mappings = mappings;
    }

    @ResponseBody
    @RequestMapping(value={"/"}, method={RequestMethod.GET})
    public RepositoryLinksResource listRepositories() {
        RepositoryLinksResource resource = new RepositoryLinksResource();
        for (Class domainType : this.repositories) {
            ResourceMetadata metadata = this.mappings.getMappingFor(domainType);
            if (!metadata.isExported()) continue;
            resource.add(this.entityLinks.linkToCollectionResource(domainType));
        }
        return resource;
    }
}

