/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.mapping;

import java.util.HashMap;
import java.util.Map;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.rest.core.mapping.MappingResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.util.Assert;

public class PropertyMappings {
    private final ResourceMappings resourceMappings;
    private final Map<PersistentProperty<?>, ResourceMetadata> resourceMetadata;

    public PropertyMappings(ResourceMappings resourceMappings) {
        Assert.notNull((Object)resourceMappings, (String)"ResourceMappings must not be null!");
        this.resourceMappings = resourceMappings;
        this.resourceMetadata = new HashMap();
    }

    public ResourceMapping getMappingFor(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        ResourceMetadata metadata = this.resourceMetadata.get(property);
        if (metadata != null) {
            return metadata.getMappingFor(property);
        }
        metadata = this.resourceMappings.getMappingFor(property.getOwner().getType());
        if (metadata != null) {
            return this.cacheAndReturn(metadata, property);
        }
        return this.cacheAndReturn((ResourceMetadata)new MappingResourceMetadata(property.getOwner()), property);
    }

    private ResourceMapping cacheAndReturn(ResourceMetadata metadata, PersistentProperty<?> property) {
        this.resourceMetadata.put(property, metadata);
        return metadata.getMappingFor(property);
    }
}

