/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.projection.ProjectionFactory;
import org.springframework.data.rest.webmvc.support.Projector;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PersistentEntityProjector
implements Projector {
    private final ProjectionDefinitions projectionDefinitions;
    private final ProjectionFactory factory;
    private final String projection;

    public PersistentEntityProjector(ProjectionDefinitions projectionDefinitions, ProjectionFactory factory, String projection) {
        Assert.notNull((Object)projectionDefinitions, (String)"ProjectionDefinitions must not be null!");
        Assert.notNull((Object)factory, (String)"ProjectionFactory must not be null!");
        this.projectionDefinitions = projectionDefinitions;
        this.factory = factory;
        this.projection = projection;
    }

    @Override
    public Object project(Object source) {
        if (!StringUtils.hasText((String)this.projection)) {
            return source;
        }
        Class projectionType = this.projectionDefinitions.getProjectionType(source.getClass(), this.projection);
        return projectionType == null ? source : this.factory.createProjection(source, projectionType);
    }
}

