/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.util;

import java.util.Map;
import org.springframework.core.MethodParameter;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.util.UriTemplate;

public abstract class UriUtils {
    private UriUtils() {
    }

    public static String findMappingVariable(String variable, MethodParameter parameter, String lookupPath) {
        Assert.hasText((String)variable, (String)"Variable name must not be null or empty!");
        Assert.notNull((Object)parameter, (String)"Method parameter must not be null!");
        RequestMapping annotation = (RequestMapping)parameter.getMethodAnnotation(RequestMapping.class);
        for (String mapping : annotation.value()) {
            Map variables = new UriTemplate(mapping).match(lookupPath);
            String value = (String)variables.get(variable);
            if (value == null) continue;
            return value;
        }
        return null;
    }
}

