/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.BaseUri;
import org.springframework.data.rest.webmvc.BaseUriAwareController;
import org.springframework.http.MediaType;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class BaseUriAwareHandlerMapping
extends RequestMappingHandlerMapping {
    private final RepositoryRestConfiguration configuration;

    public BaseUriAwareHandlerMapping(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.configuration = configuration;
        this.setOrder(2147483497);
    }

    protected HandlerMethod lookupHandlerMethod(String lookupPath, HttpServletRequest request) throws Exception {
        String acceptType = request.getHeader("Accept");
        if (null == acceptType) {
            acceptType = this.configuration.getDefaultMediaType().toString();
        }
        List acceptHeaderTypes = MediaType.parseMediaTypes((String)acceptType);
        ArrayList<MediaType> acceptableTypes = new ArrayList<MediaType>();
        for (MediaType mt : acceptHeaderTypes) {
            if ("*".equals(mt.getType()) && "*".equals(mt.getSubtype()) || "application".equals(mt.getType()) && "*".equals(mt.getSubtype())) {
                mt = this.configuration.getDefaultMediaType();
            }
            if (acceptableTypes.contains(mt)) continue;
            acceptableTypes.add(mt);
        }
        acceptType = acceptableTypes.size() > 1 ? StringUtils.collectionToDelimitedString(acceptableTypes, (String)",") : (acceptableTypes.size() == 1 ? ((MediaType)acceptableTypes.get(0)).toString() : this.configuration.getDefaultMediaType().toString());
        String uri = new BaseUri(this.configuration.getBaseUri()).getRepositoryLookupPath(lookupPath);
        if (uri == null) {
            return null;
        }
        uri = StringUtils.hasText((String)uri) ? uri : "/";
        DefaultAcceptTypeHttpServletRequest wrapper = new DefaultAcceptTypeHttpServletRequest(request, acceptType, uri);
        return this.supportsLookupPath(uri) ? super.lookupHandlerMethod(uri, (HttpServletRequest)wrapper) : null;
    }

    protected boolean supportsLookupPath(String lookupPath) {
        return true;
    }

    protected boolean isHandler(Class<?> beanType) {
        return beanType.getAnnotation(BaseUriAwareController.class) != null;
    }

    private static class DefaultAcceptTypeHttpServletRequest
    extends HttpServletRequestWrapper {
        private final String defaultAcceptType;
        private final String requestUri;

        private DefaultAcceptTypeHttpServletRequest(HttpServletRequest request, String defaultAcceptType) {
            this(request, defaultAcceptType, null);
        }

        private DefaultAcceptTypeHttpServletRequest(HttpServletRequest request, String defaultAcceptType, String requestUri) {
            super(request);
            this.defaultAcceptType = defaultAcceptType;
            this.requestUri = requestUri;
        }

        public String getHeader(String name) {
            if ("accept".equals(name.toLowerCase())) {
                return this.defaultAcceptType;
            }
            return super.getHeader(name);
        }

        public String getRequestURI() {
            return this.requestUri != null ? this.requestUri : super.getRequestURI();
        }

        public String getServletPath() {
            return this.requestUri != null ? this.requestUri : super.getServletPath();
        }
    }
}

