/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import java.util.Iterator;
import java.util.List;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.util.Assert;

public class JacksonMetadata
implements Iterable<BeanPropertyDefinition> {
    private final List<BeanPropertyDefinition> definitions;

    public JacksonMetadata(ObjectMapper mapper, Class<?> type) {
        Assert.notNull((Object)mapper, (String)"ObjectMapper must not be null!");
        Assert.notNull(type, (String)"Type must not be null!");
        SerializationConfig serializationConfig = mapper.getSerializationConfig();
        JavaType javaType = serializationConfig.constructType(type);
        BeanDescription description = serializationConfig.introspect(javaType);
        this.definitions = description.findProperties();
    }

    public BeanPropertyDefinition getDefinitionFor(PersistentProperty<?> property) {
        Assert.notNull(property, (String)"PersistentProperty must not be null!");
        for (BeanPropertyDefinition definition : this.definitions) {
            if (!definition.getInternalName().equals(property.getName())) continue;
            return definition;
        }
        return null;
    }

    public boolean isExported(PersistentProperty<?> property) {
        return this.getDefinitionFor(property) != null;
    }

    @Override
    public Iterator<BeanPropertyDefinition> iterator() {
        return this.definitions.iterator();
    }
}

