/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryLinksResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.ResourceProcessor;
import org.springframework.util.Assert;

public class ProfileResourceProcessor
implements ResourceProcessor<RepositoryLinksResource> {
    static final String PROFILE_REL = "profile";
    private final RepositoryRestConfiguration configuration;

    @Autowired
    public ProfileResourceProcessor(RepositoryRestConfiguration configuration) {
        Assert.notNull((Object)configuration, (String)"RepositoryRestConfiguration must not be null!");
        this.configuration = configuration;
    }

    public RepositoryLinksResource process(RepositoryLinksResource resource) {
        resource.add(new Link(ProfileController.getRootPath(this.configuration), PROFILE_REL));
        return resource;
    }
}

