/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import org.hibernate.Version;
import org.springframework.util.ClassUtils;

public class Jackson2DatatypeHelper {
    private static final boolean IS_HIBERNATE_AVAILABLE = ClassUtils.isPresent((String)"org.hibernate.Version", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());
    private static final boolean IS_HIBERNATE4_MODULE_AVAILABLE = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());
    private static final boolean IS_JODA_MODULE_AVAILABLE = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.joda.JodaModule", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());

    public static void configureObjectMapper(ObjectMapper mapper) {
        if (IS_HIBERNATE_AVAILABLE && Hibernate4Checker.isHibernate4() && IS_HIBERNATE4_MODULE_AVAILABLE) {
            Hibernate4ModuleRegistrar.registerModule(mapper);
        }
        if (IS_JODA_MODULE_AVAILABLE) {
            JodaModuleRegistrar.registerModule(mapper);
        }
    }

    private static class JodaModuleRegistrar {
        private JodaModuleRegistrar() {
        }

        public static void registerModule(ObjectMapper mapper) {
            mapper.registerModule((Module)new JodaModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
        }
    }

    private static class Hibernate4ModuleRegistrar {
        private Hibernate4ModuleRegistrar() {
        }

        public static void registerModule(ObjectMapper mapper) {
            Hibernate4Module module = new Hibernate4Module();
            module.enable(Hibernate4Module.Feature.FORCE_LAZY_LOADING);
            mapper.registerModule((Module)module);
        }
    }

    private static class Hibernate4Checker {
        private Hibernate4Checker() {
        }

        public static boolean isHibernate4() {
            return Version.getVersionString().startsWith("4");
        }
    }
}

