/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.AfterCreateEvent;
import org.springframework.data.rest.core.event.AfterDeleteEvent;
import org.springframework.data.rest.core.event.AfterSaveEvent;
import org.springframework.data.rest.core.event.BeforeCreateEvent;
import org.springframework.data.rest.core.event.BeforeDeleteEvent;
import org.springframework.data.rest.core.event.BeforeSaveEvent;
import org.springframework.data.rest.core.mapping.ResourceMapping;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.core.mapping.ResourceType;
import org.springframework.data.rest.core.mapping.SearchResourceMappings;
import org.springframework.data.rest.core.mapping.SupportedHttpMethods;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.ControllerUtils;
import org.springframework.data.rest.webmvc.HttpHeadersPreparer;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.ProfileController;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.ResourceStatus;
import org.springframework.data.rest.webmvc.RestMediaTypes;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.support.BackendId;
import org.springframework.data.rest.webmvc.support.DefaultedPageable;
import org.springframework.data.rest.webmvc.support.ETag;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.Resources;
import org.springframework.hateoas.UriTemplate;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RepositoryRestController
class RepositoryEntityController
extends AbstractRepositoryRestController
implements ApplicationEventPublisherAware {
    private static final String BASE_MAPPING = "/{repository}";
    private static final List<String> ACCEPT_PATCH_HEADERS = Arrays.asList(RestMediaTypes.MERGE_PATCH_JSON.toString(), RestMediaTypes.JSON_PATCH_JSON.toString(), "application/json");
    private static final String ACCEPT_HEADER = "Accept";
    private static final String LINK_HEADER = "Link";
    private final RepositoryEntityLinks entityLinks;
    private final RepositoryRestConfiguration config;
    private final HttpHeadersPreparer headersPreparer;
    private final ResourceStatus resourceStatus;
    private ApplicationEventPublisher publisher;

    @Autowired
    public RepositoryEntityController(Repositories repositories, RepositoryRestConfiguration config, RepositoryEntityLinks entityLinks, PagedResourcesAssembler<Object> assembler, HttpHeadersPreparer headersPreparer) {
        super(assembler);
        this.entityLinks = entityLinks;
        this.config = config;
        this.headersPreparer = headersPreparer;
        this.resourceStatus = ResourceStatus.of(headersPreparer);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<?> optionsForCollectionResource(RootResourceInformation information) {
        HttpHeaders headers = new HttpHeaders();
        SupportedHttpMethods supportedMethods = information.getSupportedMethods();
        headers.setAllow(supportedMethods.getMethodsFor(ResourceType.COLLECTION));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}"}, method={RequestMethod.HEAD})
    public ResponseEntity<?> headCollectionResource(RootResourceInformation resourceInformation, DefaultedPageable pageable) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.HEAD, ResourceType.COLLECTION);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (null == invoker) {
            throw new ResourceNotFoundException();
        }
        List<Link> links = this.getCollectionResourceLinks(resourceInformation, pageable);
        links.add(0, this.getDefaultSelfLink());
        HttpHeaders headers = new HttpHeaders();
        headers.add(LINK_HEADER, new Links(links).toString());
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.NO_CONTENT);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET})
    public Resources<?> getCollectionResource(@QuerydslPredicate RootResourceInformation resourceInformation, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.GET, ResourceType.COLLECTION);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        if (null == invoker) {
            throw new ResourceNotFoundException();
        }
        Iterable results = pageable.getPageable() != null ? invoker.invokeFindAll(pageable.getPageable()) : invoker.invokeFindAll(sort);
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        Optional<Link> baseLink = Optional.of(this.entityLinks.linkToPagedResource(resourceInformation.getDomainType(), pageable.isDefault() ? null : pageable.getPageable()));
        Resources<?> result = this.toResources(results, assembler, metadata.getDomainType(), baseLink);
        result.add(this.getCollectionResourceLinks(resourceInformation, pageable));
        return result;
    }

    private List<Link> getCollectionResourceLinks(RootResourceInformation resourceInformation, DefaultedPageable pageable) {
        ResourceMetadata metadata = resourceInformation.getResourceMetadata();
        SearchResourceMappings searchMappings = metadata.getSearchResourceMappings();
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(new Link(ProfileController.getPath(this.config, (ResourceMapping)metadata), "profile"));
        if (searchMappings.isExported()) {
            links.add(this.entityLinks.linkFor(metadata.getDomainType()).slash((Object)searchMappings.getPath()).withRel(searchMappings.getRel()));
        }
        return links;
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json", "text/uri-list"})
    public Resources<?> getCollectionResourceCompact(@QuerydslPredicate RootResourceInformation resourceinformation, DefaultedPageable pageable, Sort sort, PersistentEntityResourceAssembler assembler) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        Resources<?> resources = this.getCollectionResource(resourceinformation, pageable, sort, assembler);
        ArrayList<Link> links = new ArrayList<Link>(resources.getLinks());
        for (Resource resource : resources.getContent()) {
            PersistentEntityResource persistentEntityResource = (PersistentEntityResource)resource;
            links.add(this.resourceLink(resourceinformation, persistentEntityResource));
        }
        if (resources instanceof PagedResources) {
            return new PagedResources(Collections.emptyList(), ((PagedResources)resources).getMetadata(), links);
        }
        return new Resources(Collections.emptyList(), links);
    }

    @ResponseBody
    @RequestMapping(value={"/{repository}"}, method={RequestMethod.POST})
    public ResponseEntity<ResourceSupport> postCollectionResource(RootResourceInformation resourceInformation, PersistentEntityResource payload, PersistentEntityResourceAssembler assembler, @RequestHeader(value="Accept", required=false) String acceptHeader) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.POST, ResourceType.COLLECTION);
        return this.createAndReturn(payload.getContent(), resourceInformation.getInvoker(), assembler, this.config.returnBodyOnCreate(acceptHeader));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.OPTIONS})
    public ResponseEntity<?> optionsForItemResource(RootResourceInformation information) {
        HttpHeaders headers = new HttpHeaders();
        SupportedHttpMethods supportedMethods = information.getSupportedMethods();
        headers.setAllow(supportedMethods.getMethodsFor(ResourceType.ITEM));
        headers.put("Accept-Patch", ACCEPT_PATCH_HEADERS);
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.HEAD})
    public ResponseEntity<?> headForItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, PersistentEntityResourceAssembler assembler) throws HttpRequestMethodNotSupportedException {
        return this.getItemResource(resourceInformation, id).map(it -> {
            Links links = new Links(assembler.toResource(it).getLinks());
            HttpHeaders headers = this.headersPreparer.prepareHeaders(resourceInformation.getPersistentEntity(), it);
            headers.add(LINK_HEADER, links.toString());
            return new ResponseEntity((MultiValueMap)headers, HttpStatus.NO_CONTENT);
        }).orElseThrow(() -> new ResourceNotFoundException());
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.GET})
    public ResponseEntity<Resource<?>> getItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, PersistentEntityResourceAssembler assembler, @RequestHeader HttpHeaders headers) throws HttpRequestMethodNotSupportedException {
        return this.getItemResource(resourceInformation, id).map(it -> {
            PersistentEntity<?, ?> entity = resourceInformation.getPersistentEntity();
            return this.resourceStatus.getStatusAndHeaders(headers, it, entity).toResponseEntity(() -> assembler.toFullResource(it));
        }).orElseGet(() -> new ResponseEntity(HttpStatus.NOT_FOUND));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PUT})
    public ResponseEntity<? extends ResourceSupport> putItemResource(RootResourceInformation resourceInformation, PersistentEntityResource payload, @BackendId Serializable id, PersistentEntityResourceAssembler assembler, ETag eTag, @RequestHeader(value="Accept", required=false) String acceptHeader) throws HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.PUT, ResourceType.ITEM);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Object objectToSave = payload.getContent();
        eTag.verify(resourceInformation.getPersistentEntity(), objectToSave);
        return payload.isNew() ? this.createAndReturn(objectToSave, invoker, assembler, this.config.returnBodyOnCreate(acceptHeader)) : this.saveAndReturn(objectToSave, invoker, HttpMethod.PUT, assembler, this.config.returnBodyOnUpdate(acceptHeader));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.PATCH})
    public ResponseEntity<ResourceSupport> patchItemResource(RootResourceInformation resourceInformation, PersistentEntityResource payload, @BackendId Serializable id, PersistentEntityResourceAssembler assembler, ETag eTag, @RequestHeader(value="Accept", required=false) String acceptHeader) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        resourceInformation.verifySupportedMethod(HttpMethod.PATCH, ResourceType.ITEM);
        Object domainObject = payload.getContent();
        eTag.verify(resourceInformation.getPersistentEntity(), domainObject);
        return this.saveAndReturn(domainObject, resourceInformation.getInvoker(), HttpMethod.PATCH, assembler, this.config.returnBodyOnUpdate(acceptHeader));
    }

    @RequestMapping(value={"/{repository}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteItemResource(RootResourceInformation resourceInformation, @BackendId Serializable id, ETag eTag) throws ResourceNotFoundException, HttpRequestMethodNotSupportedException {
        resourceInformation.verifySupportedMethod(HttpMethod.DELETE, ResourceType.ITEM);
        RepositoryInvoker invoker = resourceInformation.getInvoker();
        Optional domainObj = invoker.invokeFindById((Object)id);
        return domainObj.map(it -> {
            PersistentEntity<?, ?> entity = resourceInformation.getPersistentEntity();
            eTag.verify(entity, it);
            this.publisher.publishEvent((ApplicationEvent)new BeforeDeleteEvent(it));
            invoker.invokeDeleteById((Object)entity.getIdentifierAccessor(it).getIdentifier().orElse(null));
            this.publisher.publishEvent((ApplicationEvent)new AfterDeleteEvent(it));
            return new ResponseEntity(HttpStatus.NO_CONTENT);
        }).orElseThrow(() -> new ResourceNotFoundException());
    }

    private ResponseEntity<ResourceSupport> saveAndReturn(Object domainObject, RepositoryInvoker invoker, HttpMethod httpMethod, PersistentEntityResourceAssembler assembler, boolean returnBody) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeSaveEvent(domainObject));
        Object obj = invoker.invokeSave(domainObject);
        this.publisher.publishEvent((ApplicationEvent)new AfterSaveEvent(obj));
        PersistentEntityResource resource = assembler.toFullResource(obj);
        HttpHeaders headers = this.headersPreparer.prepareHeaders(Optional.of(resource));
        if (HttpMethod.PUT.equals((Object)httpMethod)) {
            this.addLocationHeader(headers, assembler, obj);
        }
        if (returnBody) {
            return ControllerUtils.toResponseEntity(HttpStatus.OK, headers, resource);
        }
        return ControllerUtils.toEmptyResponse(HttpStatus.NO_CONTENT, headers);
    }

    private ResponseEntity<ResourceSupport> createAndReturn(Object domainObject, RepositoryInvoker invoker, PersistentEntityResourceAssembler assembler, boolean returnBody) {
        this.publisher.publishEvent((ApplicationEvent)new BeforeCreateEvent(domainObject));
        Object savedObject = invoker.invokeSave(domainObject);
        this.publisher.publishEvent((ApplicationEvent)new AfterCreateEvent(savedObject));
        Optional<Object> resource = Optional.ofNullable(returnBody ? assembler.toFullResource(savedObject) : null);
        HttpHeaders headers = this.headersPreparer.prepareHeaders(resource);
        this.addLocationHeader(headers, assembler, savedObject);
        return ControllerUtils.toResponseEntity(HttpStatus.CREATED, headers, resource);
    }

    private void addLocationHeader(HttpHeaders headers, PersistentEntityResourceAssembler assembler, Object source) {
        String selfLink = assembler.getSelfLinkFor(source).getHref();
        headers.setLocation(new UriTemplate(selfLink).expand(new Object[0]));
    }

    private Optional<Object> getItemResource(RootResourceInformation resourceInformation, Serializable id) throws HttpRequestMethodNotSupportedException, ResourceNotFoundException {
        resourceInformation.verifySupportedMethod(HttpMethod.GET, ResourceType.ITEM);
        return resourceInformation.getInvoker().invokeFindById((Object)id);
    }
}

