/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.web.HttpMediaTypeNotAcceptableException;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.UnsatisfiedServletRequestParameterException;
import org.springframework.web.servlet.HandlerExecutionChain;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.handler.MatchableHandlerMapping;
import org.springframework.web.servlet.handler.RequestMatchResult;

public class DelegatingHandlerMapping
implements HandlerMapping,
Ordered,
MatchableHandlerMapping {
    private final List<HandlerMapping> delegates;

    public DelegatingHandlerMapping(List<HandlerMapping> delegates) {
        Assert.notNull(delegates, (String)"Delegates must not be null!");
        this.delegates = delegates;
    }

    public int getOrder() {
        return 2147483547;
    }

    public HandlerExecutionChain getHandler(HttpServletRequest request) throws Exception {
        return HandlerSelectionResult.from(request, this.delegates).resultOrException();
    }

    public RequestMatchResult match(HttpServletRequest request, String pattern) {
        try {
            return HandlerSelectionResult.from(request, this.delegates).match(pattern);
        }
        catch (Exception o_O) {
            return null;
        }
    }

    public List<HandlerMapping> getDelegates() {
        return this.delegates;
    }

    private static final class HandlerSelectionResult {
        @NonNull
        private final HttpServletRequest request;
        private final HandlerMapping mapping;
        private final HandlerExecutionChain result;
        private final Exception ignoredException;

        public static HandlerSelectionResult from(HttpServletRequest request, Iterable<HandlerMapping> delegates) throws Exception {
            Throwable ignoredException = null;
            for (HandlerMapping delegate : delegates) {
                try {
                    HandlerExecutionChain result = delegate.getHandler(request);
                    if (result == null) continue;
                    return HandlerSelectionResult.forResult(request, delegate, result);
                }
                catch (HttpMediaTypeNotAcceptableException o_O) {
                    ignoredException = o_O;
                }
                catch (HttpRequestMethodNotSupportedException o_O) {
                    ignoredException = o_O;
                }
                catch (UnsatisfiedServletRequestParameterException o_O) {
                    ignoredException = o_O;
                }
            }
            return HandlerSelectionResult.withoutResult(request, ignoredException);
        }

        private static HandlerSelectionResult forResult(HttpServletRequest request, HandlerMapping delegate, HandlerExecutionChain result) {
            return new HandlerSelectionResult(request, delegate, result, null);
        }

        private static HandlerSelectionResult withoutResult(HttpServletRequest request, Exception exception) {
            return new HandlerSelectionResult(request, null, null, exception);
        }

        public HandlerExecutionChain resultOrException() throws Exception {
            if (this.ignoredException != null) {
                throw this.ignoredException;
            }
            return this.result;
        }

        public RequestMatchResult match(String pattern) {
            return MatchableHandlerMapping.class.isInstance(this.mapping) ? ((MatchableHandlerMapping)this.mapping).match(this.request, pattern) : null;
        }

        public HandlerSelectionResult(@NonNull HttpServletRequest request, HandlerMapping mapping, HandlerExecutionChain result, Exception ignoredException) {
            if (request == null) {
                throw new IllegalArgumentException("request is null");
            }
            this.request = request;
            this.mapping = mapping;
            this.result = result;
            this.ignoredException = ignoredException;
        }

        @NonNull
        public HttpServletRequest getRequest() {
            return this.request;
        }

        public HandlerMapping getMapping() {
            return this.mapping;
        }

        public HandlerExecutionChain getResult() {
            return this.result;
        }

        public Exception getIgnoredException() {
            return this.ignoredException;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandlerSelectionResult)) {
                return false;
            }
            HandlerSelectionResult other = (HandlerSelectionResult)o;
            HttpServletRequest this$request = this.getRequest();
            HttpServletRequest other$request = other.getRequest();
            if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
                return false;
            }
            HandlerMapping this$mapping = this.getMapping();
            HandlerMapping other$mapping = other.getMapping();
            if (this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping)) {
                return false;
            }
            HandlerExecutionChain this$result = this.getResult();
            HandlerExecutionChain other$result = other.getResult();
            if (this$result == null ? other$result != null : !this$result.equals(other$result)) {
                return false;
            }
            Exception this$ignoredException = this.getIgnoredException();
            Exception other$ignoredException = other.getIgnoredException();
            return !(this$ignoredException == null ? other$ignoredException != null : !this$ignoredException.equals(other$ignoredException));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            HttpServletRequest $request = this.getRequest();
            result = result * 59 + ($request == null ? 43 : $request.hashCode());
            HandlerMapping $mapping = this.getMapping();
            result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
            HandlerExecutionChain $result = this.getResult();
            result = result * 59 + ($result == null ? 43 : $result.hashCode());
            Exception $ignoredException = this.getIgnoredException();
            result = result * 59 + ($ignoredException == null ? 43 : $ignoredException.hashCode());
            return result;
        }

        public String toString() {
            return "DelegatingHandlerMapping.HandlerSelectionResult(request=" + this.getRequest() + ", mapping=" + this.getMapping() + ", result=" + this.getResult() + ", ignoredException=" + this.getIgnoredException() + ")";
        }
    }
}

