/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.rest.core.config.RepositoryRestConfiguration;
import org.springframework.data.rest.core.event.ValidatingRepositoryEventListener;
import org.springframework.data.rest.webmvc.config.RepositoryRestConfigurer;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.util.Assert;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;

class RepositoryRestConfigurerDelegate
implements RepositoryRestConfigurer {
    private final Iterable<RepositoryRestConfigurer> delegates;

    public RepositoryRestConfigurerDelegate(Iterable<RepositoryRestConfigurer> delegates) {
        Assert.notNull(delegates, (String)"RepositoryRestConfigurers must not be null!");
        this.delegates = delegates;
    }

    @Override
    public void configureRepositoryRestConfiguration(RepositoryRestConfiguration config, CorsRegistry cors) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureRepositoryRestConfiguration(config, cors);
        }
    }

    @Override
    public void configureConversionService(ConfigurableConversionService conversionService) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureConversionService(conversionService);
        }
    }

    @Override
    public void configureExceptionHandlerExceptionResolver(ExceptionHandlerExceptionResolver exceptionResolver) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureExceptionHandlerExceptionResolver(exceptionResolver);
        }
    }

    @Override
    public void configureHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureHttpMessageConverters(messageConverters);
        }
    }

    @Override
    public void configureJacksonObjectMapper(ObjectMapper objectMapper) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureJacksonObjectMapper(objectMapper);
        }
    }

    @Override
    public void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
        for (RepositoryRestConfigurer configurer : this.delegates) {
            configurer.configureValidatingRepositoryEventListener(validatingListener);
        }
    }
}

