/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import org.jspecify.annotations.Nullable;
import org.springframework.core.MethodParameter;
import org.springframework.data.mapping.context.PersistentEntities;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.projection.ProjectionDefinitions;
import org.springframework.data.rest.core.support.SelfLinkProvider;
import org.springframework.data.rest.webmvc.PersistentEntityResourceAssembler;
import org.springframework.data.rest.webmvc.mapping.Associations;
import org.springframework.data.rest.webmvc.support.PersistentEntityProjector;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PersistentEntityResourceAssemblerArgumentResolver
implements HandlerMethodArgumentResolver {
    private final PersistentEntities entities;
    private final SelfLinkProvider linkProvider;
    private final ProjectionDefinitions projectionDefinitions;
    private final ProjectionFactory projectionFactory;
    private final Associations associations;

    public PersistentEntityResourceAssemblerArgumentResolver(PersistentEntities entities, SelfLinkProvider linkProvider, ProjectionDefinitions projectionDefinitions, ProjectionFactory projectionFactory, Associations associations) {
        Assert.notNull((Object)entities, (String)"PersistentEntities must not be null");
        Assert.notNull((Object)linkProvider, (String)"SelfLinkProvider must not be null");
        Assert.notNull((Object)projectionDefinitions, (String)"ProjectionDefinitions must not be null");
        Assert.notNull((Object)projectionFactory, (String)"ProjectionFactory must not be null");
        Assert.notNull((Object)associations, (String)"Associations must not be null");
        this.entities = entities;
        this.linkProvider = linkProvider;
        this.projectionDefinitions = projectionDefinitions;
        this.projectionFactory = projectionFactory;
        this.associations = associations;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResourceAssembler.class.equals((Object)parameter.getParameterType());
    }

    public PersistentEntityResourceAssembler resolveArgument(MethodParameter parameter, @Nullable ModelAndViewContainer mavContainer, NativeWebRequest webRequest, @Nullable WebDataBinderFactory binderFactory) throws Exception {
        String projectionParameter = webRequest.getParameter(this.projectionDefinitions.getParameterName());
        PersistentEntityProjector projector = new PersistentEntityProjector(this.projectionDefinitions, this.projectionFactory, projectionParameter, this.associations.getMappings());
        return new PersistentEntityResourceAssembler(this.entities, projector, this.associations, this.linkProvider);
    }
}

