/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.util;

import java.io.InputStream;
import java.util.function.Supplier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.util.Assert;
import org.springframework.util.function.ThrowingSupplier;

public class InputStreamHttpInputMessage
implements HttpInputMessage {
    private final Supplier<InputStream> body;

    private InputStreamHttpInputMessage(Supplier<InputStream> body) {
        Assert.notNull(body, (String)"InputStream must not be null");
        this.body = body;
    }

    public static InputStreamHttpInputMessage of(InputStream body) {
        return new InputStreamHttpInputMessage(() -> body);
    }

    public static InputStreamHttpInputMessage of(ThrowingSupplier<InputStream> body) {
        return new InputStreamHttpInputMessage((Supplier<InputStream>)body);
    }

    public InputStream getBody() {
        return this.body.get();
    }

    public HttpHeaders getHeaders() {
        return HttpHeaders.EMPTY;
    }
}

