/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.solr.client.solrj.SolrQuery;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.NumberConverters;
import org.springframework.data.solr.core.geo.BoundingBox;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.QueryStringHolder;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryParser {
    public static final String WILDCARD = "*";
    private static final String DELIMINATOR = ":";
    public static final String CRITERIA_VALUE_SEPERATOR = " ";
    private static final String RANGE_OPERATOR = " TO ";
    private static final String DOUBLEQUOTE = "\"";
    private static final String[] RESERVED_CHARS = new String[]{"\"", "+", "-", "&&", "||", "!", "(", ")", "{", "}", "[", "]", "^", "~", "*", "?", ":", "\\"};
    private static final String[] RESERVED_CHARS_REPLACEMENT = new String[]{"\\\"", "\\+", "\\-", "\\&\\&", "\\|\\|", "\\!", "\\(", "\\)", "\\{", "\\}", "\\[", "\\]", "\\^", "\\~", "\\*", "\\?", "\\:", "\\\\"};
    private final GenericConversionService conversionService = new GenericConversionService();

    public QueryParser() {
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Number.class, String.class)) {
            this.conversionService.addConverter((Converter)NumberConverters.NumberConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(GeoLocation.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.GeoLocationToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Distance.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.DistanceToStringConverter.INSTANCE);
        }
    }

    public final SolrQuery constructSolrQuery(SolrDataQuery query) {
        Assert.notNull((Object)query, (String)"Cannot construct solrQuery from null value.");
        Assert.notNull((Object)query.getCriteria(), (String)"Query has to have a criteria.");
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setParam("q", new String[]{this.getQueryString(query)});
        if (query instanceof Query) {
            this.processQueryOptions(solrQuery, (Query)query);
        }
        if (query instanceof FacetQuery) {
            this.processFacetOptions(solrQuery, (FacetQuery)query);
        }
        return solrQuery;
    }

    private void processQueryOptions(SolrQuery solrQuery, Query query) {
        this.appendPagination(solrQuery, query.getPageRequest());
        this.appendProjectionOnFields(solrQuery, query.getProjectionOnFields());
        this.appendGroupByFields(solrQuery, query.getGroupByFields());
        this.appendFilterQuery(solrQuery, query.getFilterQueries());
        this.appendSort(solrQuery, query.getSort());
        this.appendDefaultOperator(solrQuery, query.getDefaultOperator());
    }

    private void processFacetOptions(SolrQuery solrQuery, FacetQuery query) {
        if (this.enableFaceting(solrQuery, query)) {
            this.appendFacetingOnFields(solrQuery, query);
            this.appendFacetingQueries(solrQuery, query);
        }
    }

    public String getQueryString(SolrDataQuery query) {
        if (query.getCriteria() == null) {
            return null;
        }
        return this.createQueryStringFromCriteria(query.getCriteria());
    }

    String createQueryStringFromCriteria(Criteria criteria) {
        StringBuilder query = new StringBuilder("");
        ListIterator<Criteria> chainIterator = criteria.getCriteriaChain().listIterator();
        while (chainIterator.hasNext()) {
            Criteria chainedCriteria = chainIterator.next();
            query.append(this.createQueryFragmentForCriteria(chainedCriteria));
            if (!chainIterator.hasNext()) continue;
            query.append(chainIterator.next().getConjunctionOperator());
            chainIterator.previous();
        }
        return query.toString();
    }

    protected String createQueryFragmentForCriteria(Criteria chainedCriteria) {
        boolean singeEntryCriteria;
        StringBuilder queryFragment = new StringBuilder();
        Iterator<Criteria.CriteriaEntry> it = chainedCriteria.getCriteriaEntries().iterator();
        boolean bl = singeEntryCriteria = chainedCriteria.getCriteriaEntries().size() == 1;
        if (chainedCriteria.getField() != null) {
            String fieldName = chainedCriteria.getField().getName();
            if (chainedCriteria.isNegating()) {
                fieldName = "-" + fieldName;
            }
            if (!this.containsFunctionCriteria(chainedCriteria.getCriteriaEntries())) {
                queryFragment.append(fieldName);
                queryFragment.append(DELIMINATOR);
            }
            if (!singeEntryCriteria) {
                queryFragment.append("(");
            }
            while (it.hasNext()) {
                Criteria.CriteriaEntry entry = it.next();
                queryFragment.append(this.processCriteriaEntry(entry.getKey(), entry.getValue(), fieldName));
                if (!it.hasNext()) continue;
                queryFragment.append(CRITERIA_VALUE_SEPERATOR);
            }
            if (!singeEntryCriteria) {
                queryFragment.append(")");
            }
            if (!Float.isNaN(chainedCriteria.getBoost())) {
                queryFragment.append("^" + chainedCriteria.getBoost());
            }
        } else if (chainedCriteria instanceof QueryStringHolder) {
            return ((QueryStringHolder)((Object)chainedCriteria)).getQueryString();
        }
        return queryFragment.toString();
    }

    private boolean containsFunctionCriteria(Set<Criteria.CriteriaEntry> chainedCriterias) {
        for (Criteria.CriteriaEntry entry : chainedCriterias) {
            if (StringUtils.equals((String)Criteria.OperationKey.WITHIN.getKey(), (String)entry.getKey())) {
                return true;
            }
            if (!StringUtils.equals((String)Criteria.OperationKey.NEAR.getKey(), (String)entry.getKey())) continue;
            return true;
        }
        return false;
    }

    private String processCriteriaEntry(String key, Object value, String fieldName) {
        if (value == null) {
            return null;
        }
        if (StringUtils.equals((String)Criteria.OperationKey.EXPRESSION.getKey(), (String)key)) {
            return value.toString();
        }
        if (StringUtils.equals((String)Criteria.OperationKey.BETWEEN.getKey(), (String)key)) {
            Object[] args = (Object[])value;
            String rangeFragment = (Boolean)args[2] != false ? "[" : "{";
            rangeFragment = rangeFragment + this.createRangeFragment(args[0], args[1]);
            rangeFragment = rangeFragment + ((Boolean)args[3] != false ? "]" : "}");
            return rangeFragment;
        }
        if (StringUtils.equals((String)Criteria.OperationKey.WITHIN.getKey(), (String)key)) {
            Object[] args = (Object[])value;
            return this.createSpatialFunctionFragment(fieldName, (GeoLocation)args[0], (Distance)args[1], "geofilt");
        }
        if (StringUtils.equals((String)Criteria.OperationKey.NEAR.getKey(), (String)key)) {
            String nearFragment;
            Object[] args = (Object[])value;
            if (args[0] instanceof BoundingBox) {
                BoundingBox box = (BoundingBox)args[0];
                nearFragment = fieldName + ":[";
                nearFragment = nearFragment + this.createRangeFragment(box.getGeoLocationStart(), box.getGeoLocationEnd());
                nearFragment = nearFragment + "]";
            } else {
                nearFragment = this.createSpatialFunctionFragment(fieldName, (GeoLocation)args[0], (Distance)args[1], "bbox");
            }
            return nearFragment;
        }
        Object filteredValue = this.filterCriteriaValue(value);
        if (StringUtils.equals((String)Criteria.OperationKey.CONTAINS.getKey(), (String)key)) {
            return WILDCARD + filteredValue + WILDCARD;
        }
        if (StringUtils.equals((String)Criteria.OperationKey.STARTS_WITH.getKey(), (String)key)) {
            return filteredValue + WILDCARD;
        }
        if (StringUtils.equals((String)Criteria.OperationKey.ENDS_WITH.getKey(), (String)key)) {
            return WILDCARD + filteredValue;
        }
        if (StringUtils.startsWith((String)key, (String)"$fuzzy")) {
            String sDistance = StringUtils.substringAfter((String)key, (String)"$fuzzy#");
            float distance = Float.NaN;
            if (StringUtils.isNotBlank((String)sDistance)) {
                distance = Float.parseFloat(sDistance);
            }
            return filteredValue + "~" + (Float.isNaN(distance) ? "" : sDistance);
        }
        return filteredValue.toString();
    }

    private Object filterCriteriaValue(Object criteriaValue) {
        if (!(criteriaValue instanceof String)) {
            if (this.conversionService.canConvert(criteriaValue.getClass(), String.class)) {
                return this.conversionService.convert(criteriaValue, String.class);
            }
            return criteriaValue;
        }
        String value = this.escapeCriteriaValue((String)criteriaValue);
        return this.processWhiteSpaces(value);
    }

    private String escapeCriteriaValue(String criteriaValue) {
        return StringUtils.replaceEach((String)criteriaValue, (String[])RESERVED_CHARS, (String[])RESERVED_CHARS_REPLACEMENT);
    }

    private String processWhiteSpaces(String criteriaValue) {
        if (StringUtils.contains((String)criteriaValue, (String)CRITERIA_VALUE_SEPERATOR)) {
            return DOUBLEQUOTE + criteriaValue + DOUBLEQUOTE;
        }
        return criteriaValue;
    }

    private String createRangeFragment(Object rangeStart, Object rangeEnd) {
        String rangeFragment = "";
        rangeFragment = rangeFragment + (rangeStart != null ? this.filterCriteriaValue(rangeStart) : WILDCARD);
        rangeFragment = rangeFragment + RANGE_OPERATOR;
        rangeFragment = rangeFragment + (rangeEnd != null ? this.filterCriteriaValue(rangeEnd) : WILDCARD);
        return rangeFragment;
    }

    private String createSpatialFunctionFragment(String fieldName, GeoLocation location, Distance distance, String function) {
        String spatialFragment = "{!" + function + " pt=";
        spatialFragment = spatialFragment + this.filterCriteriaValue(location);
        spatialFragment = spatialFragment + " sfield=" + fieldName;
        spatialFragment = spatialFragment + " d=" + this.filterCriteriaValue(distance);
        spatialFragment = spatialFragment + "}";
        return spatialFragment;
    }

    private void appendPagination(SolrQuery query, Pageable pageable) {
        if (pageable == null) {
            return;
        }
        query.setStart(Integer.valueOf(pageable.getOffset()));
        query.setRows(Integer.valueOf(pageable.getPageSize()));
    }

    private void appendProjectionOnFields(SolrQuery solrQuery, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        solrQuery.setParam("fl", new String[]{StringUtils.join(fields, (String)",")});
    }

    private boolean enableFaceting(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        if (facetOptions == null || !facetOptions.hasFields() && !facetOptions.hasFacetQueries()) {
            return false;
        }
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(facetOptions.getFacetMinCount());
        solrQuery.setFacetLimit(facetOptions.getPageable().getPageSize());
        if (facetOptions.getPageable().getPageNumber() > 0) {
            solrQuery.set("facet.offset", facetOptions.getPageable().getOffset());
        }
        if (FacetOptions.FacetSort.INDEX.equals((Object)facetOptions.getFacetSort())) {
            solrQuery.setFacetSort("index");
        }
        return true;
    }

    private void appendFacetingOnFields(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        if (facetOptions.getPageable().getPageNumber() > 0) {
            solrQuery.set("facet.offset", facetOptions.getPageable().getOffset());
        }
        solrQuery.addFacetField(this.convertFieldListToStringArray(facetOptions.getFacetOnFields()));
    }

    private void appendFacetingQueries(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        for (SolrDataQuery fq : facetOptions.getFacetQueries()) {
            String facetQueryString = this.getQueryString(fq);
            if (!StringUtils.isNotBlank((String)facetQueryString)) continue;
            solrQuery.addFacetQuery(facetQueryString);
        }
    }

    private void appendGroupByFields(SolrQuery solrQuery, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        if (fields.size() > 1) {
            throw new InvalidDataAccessApiUsageException("Cannot group on more than one field with current SolrJ API. Group on single field insead");
        }
        solrQuery.set("group", true);
        solrQuery.setParam("group.main", true);
        for (Field field : fields) {
            solrQuery.add("group.field", new String[]{field.getName()});
        }
    }

    private void appendFilterQuery(SolrQuery solrQuery, List<FilterQuery> filterQueries) {
        if (CollectionUtils.isEmpty(filterQueries)) {
            return;
        }
        List<String> filterQueryStrings = this.getFilterQueryStrings(filterQueries);
        if (!filterQueryStrings.isEmpty()) {
            solrQuery.setFilterQueries(this.convertStringListToArray(filterQueryStrings));
        }
    }

    private void appendSort(SolrQuery solrQuery, Sort sort) {
        if (sort == null) {
            return;
        }
        for (Sort.Order order : sort) {
            solrQuery.addSortField(order.getProperty(), order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
    }

    private void appendDefaultOperator(SolrQuery solrQuery, Query.Operator defaultOperator) {
        if (defaultOperator != null && !Query.Operator.NONE.equals((Object)defaultOperator)) {
            solrQuery.set("q.op", new String[]{defaultOperator.asQueryStringRepresentation()});
        }
    }

    private String[] convertFieldListToStringArray(List<Field> fields) {
        String[] strResult = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            strResult[i] = fields.get(i).getName();
        }
        return strResult;
    }

    private String[] convertStringListToArray(List<String> listOfString) {
        String[] strResult = new String[listOfString.size()];
        listOfString.toArray(strResult);
        return strResult;
    }

    private List<String> getFilterQueryStrings(List<FilterQuery> filterQueries) {
        ArrayList<String> filterQueryStrings = new ArrayList<String>(filterQueries.size());
        for (FilterQuery filterQuery : filterQueries) {
            String filterQueryString = this.getQueryString(filterQuery);
            if (!StringUtils.isNotBlank((String)filterQueryString)) continue;
            filterQueryStrings.add(filterQueryString);
        }
        return filterQueryStrings;
    }

    public void registerConverter(Converter<?, ?> converter) {
        this.conversionService.addConverter(converter);
    }
}

