/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.convert;

import java.util.Date;
import org.apache.solr.client.solrj.util.ClientUtils;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.springframework.core.convert.converter.Converter;

public final class DateTimeConverters {
    private static DateTimeFormatter formatter = ISODateTimeFormat.dateTime().withZoneUTC();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JavaDateConverter implements Converter<Date, String>
    {
        INSTANCE;


        public String convert(Date source) {
            if (source == null) {
                return null;
            }
            return ClientUtils.escapeQueryChars((String)formatter.print(source.getTime()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JodaLocalDateTimeConverter implements Converter<LocalDateTime, String>
    {
        INSTANCE;


        public String convert(LocalDateTime source) {
            if (source == null) {
                return null;
            }
            return ClientUtils.escapeQueryChars((String)formatter.print(source.toDateTime(DateTimeZone.UTC).getMillis()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JodaDateTimeConverter implements Converter<ReadableInstant, String>
    {
        INSTANCE;


        public String convert(ReadableInstant source) {
            if (source == null) {
                return null;
            }
            return ClientUtils.escapeQueryChars((String)formatter.print(source.getMillis()));
        }
    }
}

