/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.geo;

public class Distance {
    private double value;
    private Unit unit;

    public Distance(double value) {
        this(value, Unit.KILOMETERS);
    }

    public Distance(double value, Unit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public double getNormalizedValue() {
        return this.unit != null ? this.unit.getMultiplier() * this.value : this.value * Unit.KILOMETERS.getMultiplier();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Unit {
        KILOMETERS(1.0),
        MILES(1.609344);

        private final double multiplier;

        private Unit(double multiplier) {
            this.multiplier = multiplier;
        }

        public double getMultiplier() {
            return this.multiplier;
        }
    }
}

