/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.solr.core.query.AbstractValueHoldingField;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.SimpleUpdateField;
import org.springframework.data.solr.core.query.Update;
import org.springframework.data.solr.core.query.UpdateAction;
import org.springframework.data.solr.core.query.UpdateField;
import org.springframework.data.solr.core.query.ValueHoldingField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartialUpdate
implements Update {
    private final ValueHoldingField idField;
    private final List<UpdateField> updates = new ArrayList<UpdateField>();

    public PartialUpdate(String idFieldName, String idFieldValue) {
        this(new IdField(idFieldName, idFieldValue));
    }

    public PartialUpdate(Field idField, String idFieldValue) {
        this(new IdField(idField.getName(), idFieldValue));
    }

    PartialUpdate(IdField idField) {
        this.idField = idField;
    }

    @Override
    public ValueHoldingField getIdField() {
        return this.idField;
    }

    public void add(String fieldName, Object value) {
        this.add(new SimpleUpdateField(fieldName, value));
    }

    public void add(UpdateField field) {
        this.updates.add(field);
    }

    public void addValueToField(String fieldName, Object value) {
        this.add(new SimpleUpdateField(fieldName, value, UpdateAction.ADD));
    }

    public void setValueOfField(String fieldName, Object value) {
        this.add(new SimpleUpdateField(fieldName, value, UpdateAction.SET));
    }

    public void increaseValueOfField(String fieldName, Object value) {
        this.add(new SimpleUpdateField(fieldName, value, UpdateAction.INC));
    }

    public List<UpdateField> getUpdates() {
        return Collections.unmodifiableList(this.updates);
    }

    static class IdField
    extends AbstractValueHoldingField {
        public IdField(String fieldName, Object fieldValue) {
            super(fieldName, fieldValue);
        }
    }
}

