/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.repository.Facet;
import org.springframework.data.solr.repository.Query;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrEntityInformationCreator;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SolrQueryMethod
extends QueryMethod {
    private final SolrEntityInformation<?, ?> entityInformation;
    private Method method;

    public SolrQueryMethod(Method method, RepositoryMetadata metadata, SolrEntityInformationCreator solrInformationCreator) {
        super(method, metadata);
        this.method = method;
        this.entityInformation = solrInformationCreator.getEntityInformation(metadata.getReturnedDomainClass(method));
    }

    public boolean hasAnnotatedQuery() {
        return this.getAnnotatedQuery() != null;
    }

    public boolean hasQueryAnnotation() {
        return this.method.getAnnotation(Query.class) != null;
    }

    String getAnnotatedQuery() {
        String query = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"value");
        return StringUtils.hasText((String)query) ? query : null;
    }

    public boolean hasAnnotatedNamedQueryName() {
        return this.getAnnotatedNamedQueryName() != null;
    }

    String getAnnotatedNamedQueryName() {
        String namedQueryName = (String)AnnotationUtils.getValue((Annotation)this.getQueryAnnotation(), (String)"name");
        return StringUtils.hasText((String)namedQueryName) ? namedQueryName : null;
    }

    private Query getQueryAnnotation() {
        return this.method.getAnnotation(Query.class);
    }

    TypeInformation<?> getReturnType() {
        return ClassTypeInformation.fromReturnTypeOf((Method)this.method);
    }

    public boolean hasProjectionFields() {
        if (this.hasQueryAnnotation()) {
            return !CollectionUtils.isEmpty(this.getProjectionFields());
        }
        return false;
    }

    public List<String> getProjectionFields() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "fields");
    }

    public boolean isFacetQuery() {
        return this.hasFacetFields() || this.hasFacetQueries();
    }

    public boolean hasFacetFields() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFacetFields());
        }
        return false;
    }

    private boolean hasFacetAnnotation() {
        return this.getFacetAnnotation() != null;
    }

    List<String> getFacetFields() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "fields");
    }

    List<String> getFacetQueries() {
        return this.getAnnotationValuesAsStringList(this.getFacetAnnotation(), "queries");
    }

    public boolean hasFacetQueries() {
        if (this.hasFacetAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFacetQueries());
        }
        return false;
    }

    private Annotation getFacetAnnotation() {
        return this.method.getAnnotation(Facet.class);
    }

    public FacetOptions getFacetOptions() {
        if (!this.isFacetQuery()) {
            return null;
        }
        FacetOptions options = new FacetOptions();
        if (this.hasFacetFields()) {
            options.addFacetOnFlieldnames(this.getFacetFields());
        }
        if (this.hasFacetQueries()) {
            for (String queryString : this.getFacetQueries()) {
                options.addFacetQuery(new SimpleQuery(new SimpleStringCriteria(queryString)));
            }
        }
        options.setFacetLimit((Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"limit"));
        options.setFacetMinCount((Integer)AnnotationUtils.getValue((Annotation)this.getFacetAnnotation(), (String)"minCount"));
        return options;
    }

    public boolean hasFilterQuery() {
        if (this.hasQueryAnnotation()) {
            return !CollectionUtils.isEmpty(this.getFilterQueries());
        }
        return false;
    }

    List<String> getFilterQueries() {
        return this.getAnnotationValuesAsStringList(this.getQueryAnnotation(), "filters");
    }

    public Query.Operator getDefaultOperator() {
        if (this.hasQueryAnnotation()) {
            return this.getQueryAnnotation().defaultOperator();
        }
        return Query.Operator.NONE;
    }

    private List<String> getAnnotationValuesAsStringList(Annotation annotation, String attribute) {
        String[] values = (String[])AnnotationUtils.getValue((Annotation)annotation, (String)attribute);
        if (values.length > 1 || values.length == 1 && StringUtils.hasText((String)values[0])) {
            return CollectionUtils.arrayToList((Object)values);
        }
        return Collections.emptyList();
    }

    public SolrEntityInformation<?, ?> getEntityInformation() {
        return this.entityInformation;
    }

    public String getNamedQueryName() {
        if (!this.hasAnnotatedNamedQueryName()) {
            return super.getNamedQueryName();
        }
        return this.getAnnotatedNamedQueryName();
    }
}

