/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.mapping;

import java.beans.PropertyDescriptor;
import java.util.HashSet;
import java.util.Set;
import org.apache.solr.client.solrj.beans.Field;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.solr.core.mapping.Indexed;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.util.StringUtils;

public class SimpleSolrPersistentProperty
extends AnnotationBasedPersistentProperty<SolrPersistentProperty>
implements SolrPersistentProperty {
    private static final String SOLRJ_FIELD_ANNOTATION_DEFAULT_VALUE = "#default";
    private static final Set<Class<?>> SUPPORTED_ID_TYPES = new HashSet(3);
    private static final Set<String> SUPPORTED_ID_PROPERTY_NAMES = new HashSet<String>(1);

    public SimpleSolrPersistentProperty(java.lang.reflect.Field field, PropertyDescriptor propertyDescriptor, PersistentEntity<?, SolrPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(field, propertyDescriptor, owner, simpleTypeHolder);
    }

    @Override
    public String getFieldName() {
        String fieldName = this.readAnnotatedFieldName();
        if (StringUtils.hasText((String)fieldName) && !SOLRJ_FIELD_ANNOTATION_DEFAULT_VALUE.equals(fieldName)) {
            return fieldName;
        }
        return this.field.getName();
    }

    private String readAnnotatedFieldName() {
        String fieldName = null;
        if (this.isAnnotationPresent(Field.class)) {
            fieldName = ((Field)this.findAnnotation(Field.class)).value();
        } else if (this.isAnnotationPresent(Indexed.class)) {
            fieldName = ((Indexed)this.findAnnotation(Indexed.class)).value();
        }
        return fieldName;
    }

    @Override
    public boolean isReadonly() {
        Indexed indexedAnnotation = this.getIndexAnnotation();
        boolean readonly = indexedAnnotation != null ? indexedAnnotation.readonly() : false;
        return readonly || this.getFieldAnnotation() == null;
    }

    public boolean isIdProperty() {
        if (super.isIdProperty()) {
            return true;
        }
        return SUPPORTED_ID_PROPERTY_NAMES.contains(this.getFieldName());
    }

    protected Association<SolrPersistentProperty> createAssociation() {
        return null;
    }

    @Override
    public boolean containsWildcard() {
        String fieldName = this.getFieldName();
        return fieldName != null ? fieldName.startsWith("*") || fieldName.endsWith("*") : false;
    }

    private Field getFieldAnnotation() {
        return (Field)this.findAnnotation(Field.class);
    }

    private Indexed getIndexAnnotation() {
        return (Indexed)this.findAnnotation(Indexed.class);
    }

    static {
        SUPPORTED_ID_TYPES.add(String.class);
        SUPPORTED_ID_TYPES.add(Long.class);
        SUPPORTED_ID_TYPES.add(Integer.class);
        SUPPORTED_ID_PROPERTY_NAMES.add("id");
    }
}

