/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.solr.core.geo.BoundingBox;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class Criteria {
    public static final String WILDCARD = "*";
    public static final String CRITERIA_VALUE_SEPERATOR = " ";
    private static final String OR_OPERATOR = " OR ";
    private static final String AND_OPERATOR = " AND ";
    private Field field;
    private float boost = Float.NaN;
    private boolean negating = false;
    private List<Criteria> criteriaChain = new ArrayList<Criteria>(1);
    private Set<CriteriaEntry> criteria = new LinkedHashSet<CriteriaEntry>();

    public Criteria() {
    }

    public Criteria(Function function) {
        Assert.notNull((Object)function, (String)"Cannot create Critiera for 'null' function.");
        this.criteriaChain.add(this.function(function));
    }

    public Criteria(String fieldname) {
        this(new SimpleField(fieldname));
    }

    public Criteria(Field field) {
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.criteriaChain.add(this);
        this.field = field;
    }

    protected Criteria(List<Criteria> criteriaChain, String fieldname) {
        this(criteriaChain, new SimpleField(fieldname));
    }

    protected Criteria(List<Criteria> criteriaChain, Field field) {
        Assert.notNull(criteriaChain, (String)"CriteriaChain must not be null");
        Assert.notNull((Object)field, (String)"Field for criteria must not be null");
        Assert.hasText((String)field.getName(), (String)"Field.name for criteria must not be null/empty");
        this.criteriaChain.addAll(criteriaChain);
        this.criteriaChain.add(this);
        this.field = field;
    }

    public static Criteria where(String fieldname) {
        return Criteria.where(new SimpleField(fieldname));
    }

    public static Criteria where(Function function) {
        return new Criteria(function);
    }

    public static Criteria where(Field field) {
        return new Criteria(field);
    }

    public Criteria and(Field field) {
        return new Criteria(this.criteriaChain, field);
    }

    public Criteria and(String fieldname) {
        return new Criteria(this.criteriaChain, fieldname);
    }

    public Criteria and(Criteria criteria) {
        this.criteriaChain.add(criteria);
        return this;
    }

    public Criteria and(Criteria ... criterias) {
        this.criteriaChain.addAll(Arrays.asList(criterias));
        return this;
    }

    public Criteria or(Field field) {
        return new OrCriteria(this.criteriaChain, field);
    }

    public Criteria or(Criteria criteria) {
        Assert.notNull((Object)criteria, (String)"Cannot chain 'null' criteria.");
        OrCriteria orConnectedCritiera = new OrCriteria(this.criteriaChain, criteria.getField());
        orConnectedCritiera.criteria.addAll(criteria.criteria);
        return orConnectedCritiera;
    }

    public Criteria or(String fieldname) {
        return this.or(new SimpleField(fieldname));
    }

    public Criteria is(Object o) {
        if (o == null) {
            return this.isNull();
        }
        this.criteria.add(new CriteriaEntry(OperationKey.EQUALS, o));
        return this;
    }

    public Criteria is(Object ... values) {
        return this.in(values);
    }

    public Criteria is(Iterable<?> values) {
        return this.in(values);
    }

    public Criteria isNull() {
        return this.between(null, null).not();
    }

    public Criteria isNotNull() {
        return this.between(null, null);
    }

    public Criteria contains(String s) {
        this.assertNoBlankInWildcardedQuery(s, true, true);
        this.criteria.add(new CriteriaEntry(OperationKey.CONTAINS, (Object)s));
        return this;
    }

    public Criteria contains(String ... values) {
        this.assertValuesPresent(values);
        return this.contains(Arrays.asList(values));
    }

    public Criteria contains(Iterable<String> values) {
        Assert.notNull(values, (String)"Collection must not be null");
        for (String value : values) {
            this.contains(value);
        }
        return this;
    }

    public Criteria startsWith(String s) {
        this.assertNoBlankInWildcardedQuery(s, false, true);
        this.criteria.add(new CriteriaEntry(OperationKey.STARTS_WITH, (Object)s));
        return this;
    }

    public Criteria startsWith(String ... values) {
        this.assertValuesPresent(values);
        return this.startsWith(Arrays.asList(values));
    }

    public Criteria startsWith(Iterable<String> values) {
        Assert.notNull(values, (String)"Collection must not be null");
        for (String value : values) {
            this.startsWith(value);
        }
        return this;
    }

    public Criteria endsWith(String s) {
        this.assertNoBlankInWildcardedQuery(s, true, false);
        this.criteria.add(new CriteriaEntry(OperationKey.ENDS_WITH, (Object)s));
        return this;
    }

    public Criteria endsWith(String ... values) {
        this.assertValuesPresent(values);
        return this.endsWith(Arrays.asList(values));
    }

    public Criteria endsWith(Iterable<String> values) {
        Assert.notNull(values, (String)"Collection must not be null");
        for (String value : values) {
            this.endsWith(value);
        }
        return this;
    }

    public Criteria not() {
        this.negating = true;
        return this;
    }

    public Criteria fuzzy(String s) {
        return this.fuzzy(s, Float.NaN);
    }

    public Criteria fuzzy(String s, float levenshteinDistance) {
        if (!Float.isNaN(levenshteinDistance) && (levenshteinDistance < 0.0f || levenshteinDistance > 1.0f)) {
            throw new InvalidDataAccessApiUsageException("Levenshtein Distance has to be within its bounds (0.0 - 1.0).");
        }
        this.criteria.add(new CriteriaEntry(OperationKey.FUZZY, (Object)new Object[]{s, Float.valueOf(levenshteinDistance)}));
        return this;
    }

    public Criteria sloppy(String phrase, int distance) {
        if (distance <= 0) {
            throw new InvalidDataAccessApiUsageException("Slop distance has to be greater than 0.");
        }
        if (!StringUtils.contains((CharSequence)phrase, (CharSequence)CRITERIA_VALUE_SEPERATOR)) {
            throw new InvalidDataAccessApiUsageException("Phrase must consist of multiple terms, separated with spaces.");
        }
        this.criteria.add(new CriteriaEntry(OperationKey.SLOPPY, (Object)new Object[]{phrase, distance}));
        return this;
    }

    public Criteria expression(String s) {
        this.criteria.add(new CriteriaEntry(OperationKey.EXPRESSION, (Object)s));
        return this;
    }

    public Criteria boost(float boost) {
        if (boost < 0.0f) {
            throw new InvalidDataAccessApiUsageException("Boost must not be negative.");
        }
        this.boost = boost;
        return this;
    }

    public Criteria between(Object lowerBound, Object upperBound) {
        return this.between(lowerBound, upperBound, true, true);
    }

    public Criteria between(Object lowerBound, Object upperBound, boolean includeLowerBound, boolean includeUppderBound) {
        this.criteria.add(new CriteriaEntry(OperationKey.BETWEEN, (Object)new Object[]{lowerBound, upperBound, includeLowerBound, includeUppderBound}));
        return this;
    }

    public Criteria lessThan(Object upperBound) {
        this.between(null, upperBound, true, false);
        return this;
    }

    public Criteria lessThanEqual(Object upperBound) {
        this.between(null, upperBound);
        return this;
    }

    public Criteria greaterThan(Object lowerBound) {
        this.between(lowerBound, null, false, true);
        return this;
    }

    public Criteria greaterThanEqual(Object lowerBound) {
        this.between(lowerBound, null);
        return this;
    }

    public Criteria in(Object ... values) {
        this.assertValuesPresent(values);
        return this.in(Arrays.asList(values));
    }

    public Criteria in(Iterable<?> values) {
        Assert.notNull(values, (String)"Collection of 'in' values must not be null");
        for (Object value : values) {
            if (value instanceof Collection) {
                this.in((Collection)value);
                continue;
            }
            this.is(value);
        }
        return this;
    }

    public Criteria within(GeoLocation location, Distance distance) {
        Assert.notNull((Object)location);
        this.assertPositiveDistanceValue(distance);
        this.criteria.add(new CriteriaEntry(OperationKey.WITHIN, (Object)new Object[]{location, distance != null ? distance : new Distance(0.0)}));
        return this;
    }

    public Criteria near(BoundingBox box) {
        this.criteria.add(new CriteriaEntry(OperationKey.NEAR, (Object)new Object[]{box}));
        return this;
    }

    public Criteria near(GeoLocation location, Distance distance) {
        Assert.notNull((Object)location, (String)"Location must not be 'null' for near criteria.");
        this.assertPositiveDistanceValue(distance);
        this.criteria.add(new CriteriaEntry(OperationKey.NEAR, (Object)new Object[]{location, distance != null ? distance : new Distance(0.0)}));
        return this;
    }

    public Criteria function(Function function) {
        Assert.notNull((Object)function, (String)"Cannot add 'null' function to criteria.");
        this.criteria.add(new CriteriaEntry(OperationKey.FUNCTION, (Object)function));
        return this;
    }

    public Field getField() {
        return this.field;
    }

    public Set<CriteriaEntry> getCriteriaEntries() {
        return Collections.unmodifiableSet(this.criteria);
    }

    public String getConjunctionOperator() {
        return AND_OPERATOR;
    }

    public List<Criteria> getCriteriaChain() {
        return Collections.unmodifiableList(this.criteriaChain);
    }

    public boolean isNegating() {
        return this.negating;
    }

    public float getBoost() {
        return this.boost;
    }

    private void assertPositiveDistanceValue(Distance distance) {
        if (distance != null && distance.getValue() < 0.0) {
            throw new InvalidDataAccessApiUsageException("distance must not be negative.");
        }
    }

    private void assertNoBlankInWildcardedQuery(String searchString, boolean leadingWildcard, boolean trailingWildcard) {
        if (StringUtils.contains((CharSequence)searchString, (CharSequence)CRITERIA_VALUE_SEPERATOR)) {
            throw new InvalidDataAccessApiUsageException("Cannot constructQuery '" + (leadingWildcard ? WILDCARD : "") + "\"" + searchString + "\"" + (trailingWildcard ? WILDCARD : "") + "'. Use epxression or mulitple clauses instead.");
        }
    }

    private void assertValuesPresent(Object ... values) {
        if (values.length == 0 || values.length > 1 && values[1] instanceof Collection) {
            throw new InvalidDataAccessApiUsageException("At least one element " + (values.length > 0 ? "of argument of type " + values[1].getClass().getName() : "") + " has to be present.");
        }
    }

    public static class CriteriaEntry {
        private String key;
        private Object value;

        public CriteriaEntry(OperationKey key, Object value) {
            this(key.getKey(), value);
        }

        public CriteriaEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }

    public static enum OperationKey {
        EQUALS("$equals"),
        CONTAINS("$contains"),
        STARTS_WITH("$startsWith"),
        ENDS_WITH("$endsWith"),
        EXPRESSION("$expression"),
        BETWEEN("$between"),
        NEAR("$near"),
        WITHIN("$within"),
        FUZZY("$fuzzy"),
        SLOPPY("$sloppy"),
        FUNCTION("$function");

        private final String key;

        private OperationKey(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    static class OrCriteria
    extends Criteria {
        public OrCriteria() {
        }

        public OrCriteria(Field field) {
            super(field);
        }

        public OrCriteria(List<Criteria> criteriaChain, Field field) {
            super(criteriaChain, field);
        }

        public OrCriteria(List<Criteria> criteriaChain, String fieldname) {
            super(criteriaChain, fieldname);
        }

        public OrCriteria(String fieldname) {
            super(fieldname);
        }

        @Override
        public String getConjunctionOperator() {
            return Criteria.OR_OPERATOR;
        }
    }
}

