/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.util.Assert;

public class GeoDistanceFunction
extends AbstractFunction {
    private static final String OPERATION = "geodist";

    private GeoDistanceFunction(String fieldName, GeoLocation location) {
        super(Arrays.asList(fieldName, location));
    }

    public static Builder distanceFrom(String fieldname) {
        return new Builder(fieldname);
    }

    public static Builder distanceFrom(Field field) {
        Assert.notNull((Object)field, (String)"Field cannot be 'null' for geodistance function.");
        return GeoDistanceFunction.distanceFrom(field.getName());
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }

    public static class Builder {
        private final String fieldname;

        public Builder(String fieldname) {
            Assert.hasText((String)fieldname, (String)"Fieldname must not be an empty.");
            this.fieldname = fieldname;
        }

        public GeoDistanceFunction to(GeoLocation geoLocation) {
            Assert.notNull((Object)geoLocation, (String)"Location for geodist function must not be 'null'");
            return new GeoDistanceFunction(this.fieldname, geoLocation);
        }

        public GeoDistanceFunction to(double latitude, double longitude) {
            return this.to(new GeoLocation(latitude, longitude));
        }
    }
}

