/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.util.Collection;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.LocalDateTime;
import org.joda.time.ReadableInstant;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.solr.VersionUtil;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.convert.DateTimeConverters;
import org.springframework.data.solr.core.convert.NumberConverters;
import org.springframework.data.solr.core.geo.Distance;
import org.springframework.data.solr.core.geo.GeoConverters;
import org.springframework.data.solr.core.geo.GeoLocation;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.HighlightOptions;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleFacetQuery;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.data.solr.core.query.SimpleHighlightQuery;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.core.query.SimpleStringCriteria;
import org.springframework.data.solr.core.query.result.FacetPage;
import org.springframework.data.solr.core.query.result.HighlightPage;
import org.springframework.data.solr.repository.query.SolrEntityInformation;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrParametersParameterAccessor;
import org.springframework.data.solr.repository.query.SolrQueryMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class AbstractSolrQuery
implements RepositoryQuery {
    private static final Pattern PARAMETER_PLACEHOLDER = Pattern.compile("\\?(\\d+)");
    private final SolrOperations solrOperations;
    private final SolrQueryMethod solrQueryMethod;
    private final GenericConversionService conversionService = new GenericConversionService();

    protected AbstractSolrQuery(SolrOperations solrOperations, SolrQueryMethod solrQueryMethod) {
        if (!this.conversionService.canConvert(Date.class, String.class)) {
            this.conversionService.addConverter((Converter)DateTimeConverters.JavaDateConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Number.class, String.class)) {
            this.conversionService.addConverter((Converter)NumberConverters.NumberConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(GeoLocation.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.GeoLocationToStringConverter.INSTANCE);
        }
        if (!this.conversionService.canConvert(Distance.class, String.class)) {
            this.conversionService.addConverter((Converter)GeoConverters.DistanceToStringConverter.INSTANCE);
        }
        if (VersionUtil.isJodaTimeAvailable()) {
            if (!this.conversionService.canConvert(ReadableInstant.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaDateTimeConverter.INSTANCE);
            }
            if (!this.conversionService.canConvert(LocalDateTime.class, String.class)) {
                this.conversionService.addConverter((Converter)DateTimeConverters.JodaLocalDateTimeConverter.INSTANCE);
            }
        }
        Assert.notNull((Object)solrOperations);
        Assert.notNull((Object)((Object)solrQueryMethod));
        this.solrOperations = solrOperations;
        this.solrQueryMethod = solrQueryMethod;
    }

    public Object execute(Object[] parameters) {
        SolrParametersParameterAccessor accessor = new SolrParametersParameterAccessor(this.solrQueryMethod, parameters);
        Query query = this.createQuery(accessor);
        this.decorateWithFilterQuery(query, accessor);
        this.setDefaultQueryOperatorIfDefined(query);
        this.setAllowedQueryExeutionTime(query);
        this.setDefTypeIfDefined(query);
        this.setRequestHandlerIfDefined(query);
        if (this.solrQueryMethod.isPageQuery()) {
            if (this.solrQueryMethod.isFacetQuery() && this.solrQueryMethod.isHighlightQuery()) {
                throw new InvalidDataAccessApiUsageException("Facet and Highlight cannot be combined.");
            }
            if (this.solrQueryMethod.isFacetQuery()) {
                FacetQuery facetQuery = SimpleFacetQuery.fromQuery(query, new SimpleFacetQuery());
                facetQuery.setFacetOptions(this.extractFacetOptions(this.solrQueryMethod, accessor));
                return new FacetPageExecution(accessor.getPageable()).execute(facetQuery);
            }
            if (this.solrQueryMethod.isHighlightQuery()) {
                HighlightQuery highlightQuery = SimpleHighlightQuery.fromQuery(query, new SimpleHighlightQuery());
                highlightQuery.setHighlightOptions(this.extractHighlightOptions(this.solrQueryMethod, accessor));
                return new HighlightPageExecution(accessor.getPageable()).execute(highlightQuery);
            }
            return new PagedExecution(accessor.getPageable()).execute(query);
        }
        if (this.solrQueryMethod.isCollectionQuery()) {
            return new CollectionExecution(accessor.getPageable()).execute(query);
        }
        return new SingleEntityExecution().execute(query);
    }

    public SolrQueryMethod getQueryMethod() {
        return this.solrQueryMethod;
    }

    private void setDefaultQueryOperatorIfDefined(Query query) {
        Query.Operator defaultOperator = this.solrQueryMethod.getDefaultOperator();
        if (defaultOperator != null && !Query.Operator.NONE.equals((Object)defaultOperator)) {
            query.setDefaultOperator(defaultOperator);
        }
    }

    private void setAllowedQueryExeutionTime(Query query) {
        Integer timeAllowed = this.solrQueryMethod.getTimeAllowed();
        if (timeAllowed != null) {
            query.setTimeAllowed(timeAllowed);
        }
    }

    private void setDefTypeIfDefined(Query query) {
        String defType = this.solrQueryMethod.getDefType();
        if (StringUtils.hasText((String)defType)) {
            query.setDefType(defType);
        }
    }

    private void setRequestHandlerIfDefined(Query query) {
        String requestHandler = this.solrQueryMethod.getRequestHandler();
        if (StringUtils.hasText((String)requestHandler)) {
            query.setRequestHandler(requestHandler);
        }
    }

    private void decorateWithFilterQuery(Query query, SolrParameterAccessor parameterAccessor) {
        if (this.solrQueryMethod.hasFilterQuery()) {
            for (String filterQuery : this.solrQueryMethod.getFilterQueries()) {
                query.addFilterQuery(this.createQueryFromString(filterQuery, parameterAccessor));
            }
        }
    }

    protected void appendProjection(Query query) {
        if (query != null && this.getQueryMethod().hasProjectionFields()) {
            for (String fieldname : this.getQueryMethod().getProjectionFields()) {
                query.addProjectionOnField(new SimpleField(fieldname));
            }
        }
    }

    protected SimpleQuery createQueryFromString(String queryString, SolrParameterAccessor parameterAccessor) {
        String parsedQueryString = this.replacePlaceholders(queryString, parameterAccessor);
        return new SimpleQuery(new SimpleStringCriteria(parsedQueryString));
    }

    private String replacePlaceholders(String input, SolrParameterAccessor accessor) {
        if (!StringUtils.hasText((String)input)) {
            return input;
        }
        Matcher matcher = PARAMETER_PLACEHOLDER.matcher(input);
        String result = input;
        while (matcher.find()) {
            String group = matcher.group();
            int index = Integer.parseInt(matcher.group(1));
            result = result.replace(group, this.getParameterWithIndex(accessor, index));
        }
        return result;
    }

    private String getParameterWithIndex(SolrParameterAccessor accessor, int index) {
        Object parameter = accessor.getBindableValue(index);
        if (parameter == null) {
            return "null";
        }
        if (this.conversionService.canConvert(parameter.getClass(), String.class)) {
            return (String)this.conversionService.convert(parameter, String.class);
        }
        if (parameter instanceof Collection) {
            StringBuilder sb = new StringBuilder();
            for (Object o : (Collection)parameter) {
                if (this.conversionService.canConvert(o.getClass(), String.class)) {
                    sb.append((String)this.conversionService.convert(o, String.class));
                } else {
                    sb.append(o.toString());
                }
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return parameter.toString();
    }

    private FacetOptions extractFacetOptions(SolrQueryMethod queryMethod, SolrParameterAccessor parameterAccessor) {
        FacetOptions options = new FacetOptions();
        if (queryMethod.hasFacetFields()) {
            options.addFacetOnFlieldnames(queryMethod.getFacetFields());
        }
        if (queryMethod.hasFacetQueries()) {
            for (String queryString : queryMethod.getFacetQueries()) {
                options.addFacetQuery(this.createQueryFromString(queryString, parameterAccessor));
            }
        }
        if (queryMethod.hasPivotFields()) {
            for (String pivot : queryMethod.getPivotFields()) {
                options.addFacetOnPivot(pivot);
            }
        }
        options.setFacetLimit(queryMethod.getFacetLimit());
        options.setFacetMinCount(queryMethod.getFacetMinCount());
        options.setFacetPrefix(this.replacePlaceholders(queryMethod.getFacetPrefix(), parameterAccessor));
        return options;
    }

    private HighlightOptions extractHighlightOptions(SolrQueryMethod queryMethod, SolrParameterAccessor accessor) {
        String queryString;
        Integer snipplets;
        Integer fragsize;
        HighlightOptions options = new HighlightOptions();
        if (queryMethod.hasHighlightFields()) {
            options.addFields(queryMethod.getHighlightFieldNames());
        }
        if ((fragsize = queryMethod.getHighlightFragsize()) != null) {
            options.setFragsize(fragsize);
        }
        if ((snipplets = queryMethod.getHighlighSnipplets()) != null) {
            options.setNrSnipplets(snipplets);
        }
        if ((queryString = queryMethod.getHighlightQuery()) != null) {
            options.setQuery(this.createQueryFromString(queryString, accessor));
        }
        this.appendHighlightFormatOptions(options, this.solrQueryMethod);
        return options;
    }

    private void appendHighlightFormatOptions(HighlightOptions options, SolrQueryMethod queryMethod) {
        String highlightPostfix;
        String highlightPrefix;
        String formatter = queryMethod.getHighlightFormatter();
        if (formatter != null) {
            options.setFormatter(formatter);
        }
        if ((highlightPrefix = queryMethod.getHighlightPrefix()) != null) {
            if (this.isSimpleHighlightingOption(formatter)) {
                options.setSimplePrefix(highlightPrefix);
            } else {
                options.addHighlightParameter(new HighlightOptions.HighlightParameter("hl.tag.pre", highlightPrefix));
            }
        }
        if ((highlightPostfix = queryMethod.getHighlightPostfix()) != null) {
            if (this.isSimpleHighlightingOption(formatter)) {
                options.setSimplePostfix(highlightPostfix);
            } else {
                options.addHighlightParameter(new HighlightOptions.HighlightParameter("hl.tag.post", highlightPostfix));
            }
        }
    }

    private boolean isSimpleHighlightingOption(String formatter) {
        return formatter == null || "simple".equalsIgnoreCase(formatter);
    }

    protected abstract Query createQuery(SolrParameterAccessor var1);

    class SingleEntityExecution
    implements QueryExecution {
        SingleEntityExecution() {
        }

        @Override
        public Object execute(Query query) {
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForObject(query, metadata.getJavaType());
        }
    }

    class HighlightPageExecution
    extends PagedExecution {
        public HighlightPageExecution(Pageable pageable) {
            super(pageable);
        }

        protected HighlightPage<?> executeFind(Query query) {
            Assert.isInstanceOf(HighlightQuery.class, (Object)query);
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForHighlightPage((HighlightQuery)query, metadata.getJavaType());
        }
    }

    class FacetPageExecution
    extends PagedExecution {
        public FacetPageExecution(Pageable pageable) {
            super(pageable);
        }

        protected FacetPage<?> executeFind(Query query) {
            Assert.isInstanceOf(FacetQuery.class, (Object)query);
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForFacetPage((FacetQuery)query, metadata.getJavaType());
        }
    }

    class PagedExecution
    extends AbstractQueryExecution {
        private final Pageable pageable;

        public PagedExecution(Pageable pageable) {
            Assert.notNull((Object)pageable);
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            query.setPageRequest(this.getPageable());
            return this.executeFind(query);
        }

        protected Pageable getPageable() {
            return this.pageable;
        }
    }

    class CollectionExecution
    extends AbstractQueryExecution {
        private final Pageable pageable;

        public CollectionExecution(Pageable pageable) {
            this.pageable = pageable;
        }

        @Override
        public Object execute(Query query) {
            query.setPageRequest((Pageable)(this.pageable != null ? this.pageable : new PageRequest(0, Math.max(1, (int)this.count(query)))));
            return this.executeFind(query).getContent();
        }

        private long count(Query query) {
            return AbstractSolrQuery.this.solrOperations.count(query);
        }
    }

    abstract class AbstractQueryExecution
    implements QueryExecution {
        AbstractQueryExecution() {
        }

        protected Page<?> executeFind(Query query) {
            SolrEntityInformation<?, ?> metadata = AbstractSolrQuery.this.solrQueryMethod.getEntityInformation();
            return AbstractSolrQuery.this.solrOperations.queryForPage(query, metadata.getJavaType());
        }
    }

    private static interface QueryExecution {
        public Object execute(Query var1);
    }
}

