/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.repository.query.AbstractSolrQuery;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.data.solr.repository.query.SolrQueryMethod;

public class StringBasedSolrQuery
extends AbstractSolrQuery {
    private final String rawQueryString;

    public StringBasedSolrQuery(SolrQueryMethod method, SolrOperations solrOperations) {
        this(method.getAnnotatedQuery(), method, solrOperations);
    }

    public StringBasedSolrQuery(String query, SolrQueryMethod queryMethod, SolrOperations solrOperations) {
        super(solrOperations, queryMethod);
        this.rawQueryString = query;
    }

    @Override
    protected Query createQuery(SolrParameterAccessor parameterAccessor) {
        SimpleQuery query = this.createQueryFromString(this.rawQueryString, parameterAccessor);
        this.appendProjection(query);
        query.addSort(parameterAccessor.getSort());
        return query;
    }
}

