/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.support;

import java.io.Serializable;
import org.apache.solr.client.solrj.SolrServer;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.core.support.TransactionalRepositoryFactoryBeanSupport;
import org.springframework.data.solr.core.SolrOperations;
import org.springframework.data.solr.repository.support.SolrRepositoryFactory;
import org.springframework.util.Assert;

public class SolrRepositoryFactoryBean<T extends Repository<S, ID>, S, ID extends Serializable>
extends TransactionalRepositoryFactoryBeanSupport<T, S, ID> {
    private SolrServer solrServer;
    private SolrOperations operations;

    public void setSolrOperations(SolrOperations operations) {
        this.operations = operations;
    }

    public void setSolrServer(SolrServer solrServer) {
        this.solrServer = solrServer;
    }

    protected SolrOperations getSolrOperations() {
        return this.operations;
    }

    public void afterPropertiesSet() {
        super.afterPropertiesSet();
        Assert.isTrue((this.operations != null || this.solrServer != null ? 1 : 0) != 0, (String)"SolrOperations or SolrServer must be configured!");
    }

    protected RepositoryFactorySupport doCreateRepositoryFactory() {
        if (this.operations != null) {
            return new SolrRepositoryFactory(this.operations);
        }
        return new SolrRepositoryFactory(this.solrServer);
    }
}

