/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public class SchemaDefinition {
    private String collectionName;
    private List<FieldDefinition> fields;
    private String name;
    private Double version;
    private String uniqueKey;

    public SchemaDefinition() {
    }

    public SchemaDefinition(String collectionName) {
        this.collectionName = collectionName;
        this.fields = new ArrayList<FieldDefinition>();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public List<FieldDefinition> getFields() {
        return this.fields;
    }

    public void setFields(List<FieldDefinition> fields) {
        this.fields = fields != null ? fields : new ArrayList();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Double getVersion() {
        return this.version;
    }

    public void setVersion(Double version) {
        this.version = version;
    }

    public String getUniqueKey() {
        return this.uniqueKey;
    }

    public void setUniqueKey(String uniqueKey) {
        this.uniqueKey = uniqueKey;
    }

    public boolean containsField(String name) {
        return this.getFieldDefinition(name) != null;
    }

    public FieldDefinition getFieldDefinition(String name) {
        if (CollectionUtils.isEmpty(this.fields)) {
            return null;
        }
        for (FieldDefinition fd : this.fields) {
            if (!ObjectUtils.nullSafeEquals((Object)fd.getName(), (Object)name)) continue;
            return fd;
        }
        return null;
    }

    public void addFieldDefinition(FieldDefinition fieldDef) {
        if (this.fields == null) {
            this.fields = new ArrayList<FieldDefinition>();
        }
        this.fields.add(fieldDef);
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public static class FieldDefinitionBuilder {
        private FieldDefinition fieldDef = new FieldDefinition();

        public FieldDefinition idFieldDefinition(String fieldname, String type) {
            this.fieldDef.setName(fieldname);
            this.fieldDef.setType(type);
            this.fieldDef.setIndexed(true);
            this.fieldDef.setStored(true);
            this.fieldDef.setMultiValued(false);
            return this.fieldDef;
        }
    }

    public static class Tokenizer {
        String clazz;
    }

    public static class Filter {
        String clazz;
        String pattern;
        String replace;
        String replacement;
    }

    public static class CopyFieldDefinition
    implements SchemaField {
        String source;
        List<String> destination;
    }

    public static class FieldDefinition
    implements SchemaField {
        private String name;
        private String type;
        private boolean stored;
        private boolean indexed;
        private Object defaultValue;
        private List<String> copyFields;
        private List<Filter> filters;
        private List<Tokenizer> tokenizers;
        private boolean multiValued;
        private boolean required;

        public FieldDefinition() {
        }

        public FieldDefinition(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public boolean isStored() {
            return this.stored;
        }

        public void setStored(boolean stored) {
            this.stored = stored;
        }

        public boolean isIndexed() {
            return this.indexed;
        }

        public void setIndexed(boolean indexed) {
            this.indexed = indexed;
        }

        public Object getDefaultValue() {
            return this.defaultValue;
        }

        public void setDefaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
        }

        public List<String> getCopyFields() {
            return this.copyFields;
        }

        public void setCopyFields(Collection<String> copyFields) {
            this.copyFields = new ArrayList<String>(copyFields);
        }

        public List<Filter> getFilters() {
            return this.filters;
        }

        public void setFilters(List<Filter> filters) {
            this.filters = filters;
        }

        public List<Tokenizer> getTokenizers() {
            return this.tokenizers;
        }

        public void setTokenizers(List<Tokenizer> tokenizers) {
            this.tokenizers = tokenizers;
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isMultiValued() {
            return this.multiValued;
        }

        public void setMultiValued(boolean multiValued) {
            this.multiValued = multiValued;
        }

        public boolean isRequired() {
            return this.required;
        }

        public void setRequired(boolean required) {
            this.required = required;
        }
    }

    public static interface SchemaField {
    }
}

