/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.server.support;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.embedded.EmbeddedSolrServer;
import org.apache.solr.core.CoreContainer;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.data.solr.server.SolrClientFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.xml.sax.SAXException;

public class EmbeddedSolrServerFactory
implements SolrClientFactory,
DisposableBean {
    private static final String SOLR_HOME_SYSTEM_PROPERTY = "solr.solr.home";
    private String solrHome;
    private EmbeddedSolrServer solrServer;

    protected EmbeddedSolrServerFactory() {
    }

    public EmbeddedSolrServerFactory(String solrHome) throws ParserConfigurationException, IOException, SAXException {
        Assert.hasText((String)solrHome);
        this.solrHome = solrHome;
    }

    public EmbeddedSolrServer getSolrClient() {
        if (this.solrServer == null) {
            this.initSolrServer();
        }
        return this.solrServer;
    }

    protected void initSolrServer() {
        try {
            this.solrServer = this.createPathConfiguredSolrServer(this.solrHome);
        }
        catch (ParserConfigurationException e) {
            throw new BeanInstantiationException(EmbeddedSolrServer.class, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new BeanInstantiationException(EmbeddedSolrServer.class, e.getMessage(), (Throwable)e);
        }
        catch (SAXException e) {
            throw new BeanInstantiationException(EmbeddedSolrServer.class, e.getMessage(), (Throwable)e);
        }
    }

    public final EmbeddedSolrServer createPathConfiguredSolrServer(String path) throws ParserConfigurationException, IOException, SAXException {
        String solrHomeDirectory = System.getProperty(SOLR_HOME_SYSTEM_PROPERTY);
        if (StringUtils.isBlank((CharSequence)solrHomeDirectory)) {
            solrHomeDirectory = ResourceUtils.getFile((String)path).getPath();
        }
        solrHomeDirectory = URLDecoder.decode(solrHomeDirectory, "utf-8");
        return new EmbeddedSolrServer(this.createCoreContainer(solrHomeDirectory), "collection1");
    }

    private CoreContainer createCoreContainer(String solrHomeDirectory) {
        File solrXmlFile = new File(solrHomeDirectory + "/solr.xml");
        if (ClassUtils.hasConstructor(CoreContainer.class, (Class[])new Class[]{String.class, File.class})) {
            return this.createCoreContainerViaConstructor(solrHomeDirectory, solrXmlFile);
        }
        return this.createCoreContainer(solrHomeDirectory, solrXmlFile);
    }

    private CoreContainer createCoreContainerViaConstructor(String solrHomeDirectory, File solrXmlFile) {
        Constructor constructor = ClassUtils.getConstructorIfAvailable(CoreContainer.class, (Class[])new Class[]{String.class, File.class});
        return (CoreContainer)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{solrHomeDirectory, solrXmlFile});
    }

    private CoreContainer createCoreContainer(String solrHomeDirectory, File solrXmlFile) {
        Method createAndLoadMethod = ClassUtils.getStaticMethod(CoreContainer.class, (String)"createAndLoad", (Class[])new Class[]{String.class, File.class});
        if (createAndLoadMethod != null) {
            return (CoreContainer)ReflectionUtils.invokeMethod((Method)createAndLoadMethod, null, (Object[])new Object[]{solrHomeDirectory, solrXmlFile});
        }
        createAndLoadMethod = ClassUtils.getStaticMethod(CoreContainer.class, (String)"createAndLoad", (Class[])new Class[]{Path.class, Path.class});
        return (CoreContainer)ReflectionUtils.invokeMethod((Method)createAndLoadMethod, null, (Object[])new Object[]{FileSystems.getDefault().getPath(solrHomeDirectory, new String[0]), FileSystems.getDefault().getPath(solrXmlFile.getPath(), new String[0])});
    }

    public void shutdownSolrServer() {
        if (this.solrServer != null && this.solrServer.getCoreContainer() != null) {
            this.solrServer.getCoreContainer().shutdown();
        }
    }

    @Override
    public List<String> getCores() {
        if (this.solrServer != null && this.solrServer.getCoreContainer() != null) {
            return new ArrayList<String>(this.solrServer.getCoreContainer().getCoreNames());
        }
        return Collections.emptyList();
    }

    public void setSolrHome(String solrHome) {
        Assert.hasText((String)solrHome);
        this.solrHome = solrHome;
    }

    public void destroy() throws Exception {
        this.shutdownSolrServer();
    }

    @Override
    public SolrClient getSolrClient(String core) {
        return this.getSolrClient();
    }
}

