/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.partition;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.springframework.batch.core.partition.support.Partitioner;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.store.split.Split;
import org.springframework.data.hadoop.store.split.SplitLocation;
import org.springframework.util.StringUtils;

public abstract class AbstractPartitioner
implements Partitioner {
    private String keyPartition = "partition";
    private String keyFileName = "fileName";
    private String keySplitStart = "splitStart";
    private String keySplitLength = "splitLength";
    private String keySplitLocations = "splitLocations";
    private Configuration configuration;

    public Map<String, ExecutionContext> partition(int gridSize) {
        return this.createPartitions();
    }

    public void setPartitionBaseIdentifier(String keyPartition) {
        this.keyPartition = keyPartition;
    }

    public String getPartitionBaseIdentifier() {
        return this.keyPartition;
    }

    public void setKeyFileName(String keyFileName) {
        this.keyFileName = keyFileName;
    }

    public String getKeyFileName() {
        return this.keyFileName;
    }

    public void setKeySplitStart(String keySplitStart) {
        this.keySplitStart = keySplitStart;
    }

    public String getKeySplitStart() {
        return this.keySplitStart;
    }

    public void setKeySplitLength(String keySplitLength) {
        this.keySplitLength = keySplitLength;
    }

    public String getKeySplitLength() {
        return this.keySplitLength;
    }

    public void setKeySplitLocations(String keySplitLocations) {
        this.keySplitLocations = keySplitLocations;
    }

    public String getKeySplitLocations() {
        return this.keySplitLocations;
    }

    @Autowired(required=false)
    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract Map<String, ExecutionContext> createPartitions();

    protected ExecutionContext createExecutionContext(Resource resource, Split split) throws IOException {
        return this.createExecutionContext(new Path(resource.getURI()), split);
    }

    protected ExecutionContext createExecutionContext(Path path, Split split) throws IOException {
        ExecutionContext context = new ExecutionContext();
        context.putString(this.getKeyFileName(), path.toUri().getPath());
        context.putLong(this.getKeySplitStart(), split.getStart());
        context.putLong(this.getKeySplitLength(), split.getLength());
        if (split instanceof SplitLocation) {
            context.putString(this.getKeySplitLocations(), StringUtils.collectionToCommaDelimitedString(Arrays.asList(((SplitLocation)split).getLocations())));
        }
        return context;
    }
}

