/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.am;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobExecutionException;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.partition.PartitionHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.SmartLifecycle;
import org.springframework.yarn.am.AppmasterService;
import org.springframework.yarn.am.YarnAppmaster;
import org.springframework.yarn.am.allocate.AbstractAllocator;
import org.springframework.yarn.batch.am.AbstractBatchAppmaster;
import org.springframework.yarn.batch.event.JobExecutionEvent;
import org.springframework.yarn.batch.partition.AbstractPartitionHandler;
import org.springframework.yarn.batch.repository.BatchAppmasterService;
import org.springframework.yarn.batch.repository.JobRepositoryRemoteServiceInterceptor;
import org.springframework.yarn.batch.repository.JobRepositoryRpcFactory;
import org.springframework.yarn.batch.repository.bindings.PartitionedStepExecutionStatusReq;
import org.springframework.yarn.batch.repository.bindings.PartitionedStepExecutionStatusRes;
import org.springframework.yarn.batch.repository.bindings.StepExecutionType;
import org.springframework.yarn.event.AbstractYarnEvent;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;
import org.springframework.yarn.integration.ip.mind.binding.BaseResponseObject;

public class BatchAppmaster
extends AbstractBatchAppmaster
implements YarnAppmaster {
    private static final Log log = LogFactory.getLog(BatchAppmaster.class);
    @Autowired(required=false)
    private final Collection<PartitionHandler> partitionHandlers = Collections.emptySet();
    private List<JobExecution> jobExecutions = new ArrayList<JobExecution>();

    public void submitApplication() {
        log.info((Object)"submitApplication");
        this.registerAppmaster();
        this.start();
        if (this.getAllocator() instanceof AbstractAllocator) {
            log.info((Object)"about to set app attempt id");
            ((AbstractAllocator)this.getAllocator()).setApplicationAttemptId(this.getApplicationAttemptId());
        }
        for (PartitionHandler handler : this.partitionHandlers) {
            if (!(handler instanceof AbstractPartitionHandler)) continue;
            ((AbstractPartitionHandler)handler).setBatchAppmaster(this);
        }
        try {
            this.getYarnJobLauncher().run(this.getParameters());
        }
        catch (JobExecutionException e) {
            log.error((Object)"Error in jobLauncherHelper", (Throwable)e);
            this.setFinalApplicationStatus(FinalApplicationStatus.FAILED);
        }
        for (JobExecution jobExecution : this.jobExecutions) {
            if (!jobExecution.getStatus().equals((Object)BatchStatus.FAILED)) continue;
            this.setFinalApplicationStatus(FinalApplicationStatus.FAILED);
            break;
        }
        this.notifyCompleted();
    }

    public void onApplicationEvent(AbstractYarnEvent event) {
        super.onApplicationEvent(event);
        if (event instanceof JobExecutionEvent) {
            this.jobExecutions.add(((JobExecutionEvent)event).getJobExecution());
        }
    }

    protected void doStart() {
        super.doStart();
        AppmasterService service = this.getAppmasterService();
        if (log.isDebugEnabled() && service != null) {
            log.debug((Object)("We have a appmaster service " + service));
        }
        if (service instanceof BatchAppmasterService) {
            ((BatchAppmasterService)service).addInterceptor(new JobRepositoryRemoteServiceInterceptor(){

                @Override
                public BaseObject preRequest(BaseObject baseObject) {
                    if (baseObject.getType().equals("PartitionedStepExecutionStatusReq")) {
                        StepExecutionType stepExecutionType = ((PartitionedStepExecutionStatusReq)baseObject).stepExecution;
                        StepExecution convertStepExecution = JobRepositoryRpcFactory.convertStepExecutionType(stepExecutionType);
                        BatchAppmaster.this.getStepExecutions().add(convertStepExecution);
                        return null;
                    }
                    return baseObject;
                }

                @Override
                public BaseResponseObject postRequest(BaseResponseObject baseResponseObject) {
                    return baseResponseObject;
                }

                @Override
                public BaseResponseObject handleRequest(BaseObject baseObject) {
                    return new PartitionedStepExecutionStatusRes();
                }
            });
        }
        if (service != null && service.hasPort()) {
            for (int i = 0; i < 10 && service.getPort() == -1; ++i) {
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (this.getAppmasterService() instanceof SmartLifecycle) {
            ((SmartLifecycle)this.getAppmasterService()).start();
        }
    }

    protected void doStop() {
        this.finishAppmaster();
    }
}

