/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.batch.repository;

import java.util.Collection;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobInstance;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.util.Assert;
import org.springframework.yarn.batch.repository.AbstractRemoteDao;
import org.springframework.yarn.batch.repository.JobRepositoryRpcFactory;
import org.springframework.yarn.batch.repository.bindings.repo.AddWithStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.AddWithStepExecutionRes;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobExecutionRes;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobExecutionWithJobInstanceReq;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobExecutionWithJobInstanceRes;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobInstanceReq;
import org.springframework.yarn.batch.repository.bindings.repo.CreateJobInstanceRes;
import org.springframework.yarn.batch.repository.bindings.repo.GetLastJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.GetLastJobExecutionRes;
import org.springframework.yarn.batch.repository.bindings.repo.GetLastStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.GetLastStepExecutionRes;
import org.springframework.yarn.batch.repository.bindings.repo.GetStepExecutionCountReq;
import org.springframework.yarn.batch.repository.bindings.repo.GetStepExecutionCountRes;
import org.springframework.yarn.batch.repository.bindings.repo.IsJobInstanceExistsReq;
import org.springframework.yarn.batch.repository.bindings.repo.IsJobInstanceExistsRes;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateExecutionContextReq;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateWithJobExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateWithJobExecutionRes;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateWithStepExecutionReq;
import org.springframework.yarn.batch.repository.bindings.repo.UpdateWithStepExecutionRes;
import org.springframework.yarn.integration.ip.mind.AppmasterMindScOperations;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;

public class RemoteJobRepository
extends AbstractRemoteDao
implements JobRepository {
    public RemoteJobRepository() {
    }

    public RemoteJobRepository(AppmasterMindScOperations appmasterScOperations) {
        super(appmasterScOperations);
    }

    public boolean isJobInstanceExists(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        try {
            IsJobInstanceExistsReq request = JobRepositoryRpcFactory.buildIsJobInstanceExistsReq(jobName, jobParameters);
            IsJobInstanceExistsRes response = (IsJobInstanceExistsRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            return response.response;
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public JobExecution createJobExecution(String jobName, JobParameters jobParameters) throws JobExecutionAlreadyRunningException, JobRestartException, JobInstanceAlreadyCompleteException {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobExecution jobExecution = null;
        try {
            CreateJobExecutionReq request = JobRepositoryRpcFactory.buildCreateJobExecutionReq(jobName, jobParameters);
            CreateJobExecutionRes response = (CreateJobExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            jobExecution = JobRepositoryRpcFactory.convertJobExecutionType(response.jobExecution);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return jobExecution;
    }

    public void update(JobExecution jobExecution) {
        try {
            UpdateWithJobExecutionReq request = JobRepositoryRpcFactory.buildSaveJobExecutionReq(jobExecution);
            UpdateWithJobExecutionRes response = (UpdateWithJobExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            jobExecution.setId(response.getId());
            jobExecution.setVersion(response.getVersion());
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public void add(StepExecution stepExecution) {
        try {
            AddWithStepExecutionReq request = JobRepositoryRpcFactory.buildAddWithStepExecutionReq(stepExecution);
            AddWithStepExecutionRes response = (AddWithStepExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            stepExecution.setId(response.getId());
            stepExecution.setVersion(response.getVersion());
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public void addAll(Collection<StepExecution> stepExecutions) {
    }

    public void update(StepExecution stepExecution) {
        try {
            UpdateWithStepExecutionReq request = JobRepositoryRpcFactory.buildUpdateWithStepExecutionReq(stepExecution);
            UpdateWithStepExecutionRes response = (UpdateWithStepExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            stepExecution.setId(response.getId());
            stepExecution.setVersion(response.getVersion());
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
    }

    public void updateExecutionContext(StepExecution stepExecution) {
        UpdateExecutionContextReq request = JobRepositoryRpcFactory.buildUpdateExecutionContextReq(stepExecution);
        this.getAppmasterScOperations().doMindRequest((BaseObject)request);
    }

    public void updateExecutionContext(JobExecution jobExecution) {
        UpdateExecutionContextReq request = JobRepositoryRpcFactory.buildUpdateExecutionContextReq(jobExecution);
        this.getAppmasterScOperations().doMindRequest((BaseObject)request);
    }

    public StepExecution getLastStepExecution(JobInstance jobInstance, String stepName) {
        GetLastStepExecutionReq request = JobRepositoryRpcFactory.buildGetLastStepExecutionReq(jobInstance, stepName);
        GetLastStepExecutionRes response = (GetLastStepExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        return JobRepositoryRpcFactory.convertStepExecutionType(response.stepExecution);
    }

    public int getStepExecutionCount(JobInstance jobInstance, String stepName) {
        GetStepExecutionCountReq request = JobRepositoryRpcFactory.buildGetStepExecutionCountReq(jobInstance, stepName);
        GetStepExecutionCountRes response = (GetStepExecutionCountRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        return response.count;
    }

    public JobExecution getLastJobExecution(String jobName, JobParameters jobParameters) {
        GetLastJobExecutionReq request = JobRepositoryRpcFactory.buildGetLastJobExecutionReq(jobName, jobParameters);
        GetLastJobExecutionRes response = (GetLastJobExecutionRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
        return JobRepositoryRpcFactory.convertJobExecutionType(response.jobExecution);
    }

    public JobInstance createJobInstance(String jobName, JobParameters jobParameters) {
        Assert.notNull((Object)jobName, (String)"Job name must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobInstance jobInstance = null;
        try {
            CreateJobInstanceReq request = JobRepositoryRpcFactory.buildCreateJobInstanceReq(jobName, jobParameters);
            CreateJobInstanceRes response = (CreateJobInstanceRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            jobInstance = JobRepositoryRpcFactory.convertJobInstanceType(response.jobInstance);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return jobInstance;
    }

    public JobExecution createJobExecution(JobInstance jobInstance, JobParameters jobParameters, String jobConfigurationLocation) {
        Assert.notNull((Object)jobInstance, (String)"Job instance must not be null.");
        Assert.notNull((Object)jobParameters, (String)"JobParameters must not be null.");
        JobExecution jobExecution = null;
        try {
            CreateJobExecutionWithJobInstanceReq request = JobRepositoryRpcFactory.buildCreateJobExecutionWithJobInstanceReq(jobInstance, jobParameters, jobConfigurationLocation);
            CreateJobExecutionWithJobInstanceRes response = (CreateJobExecutionWithJobInstanceRes)this.getAppmasterScOperations().doMindRequest((BaseObject)request);
            jobExecution = JobRepositoryRpcFactory.convertJobExecutionType(response.jobExecution);
        }
        catch (Exception e) {
            throw this.convertException(e);
        }
        return jobExecution;
    }
}

