/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.condition;

import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.StringUtils;

class OnYarnAppmasterCondition
extends SpringBootCondition {
    private static final String TOKEN_ENV = "HADOOP_TOKEN_FILE_LOCATION";

    OnYarnAppmasterCondition() {
    }

    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        String[] split;
        String tokenEnv = System.getenv(TOKEN_ENV);
        if (!StringUtils.hasText((String)tokenEnv)) {
            tokenEnv = System.getProperty(TOKEN_ENV);
        }
        if (tokenEnv != null && (split = tokenEnv.split("/")).length > 2 && split[split.length - 2].endsWith("00001")) {
            return ConditionOutcome.match((String)("Detected container id " + split[split.length - 2] + " ending with '00001'"));
        }
        return ConditionOutcome.noMatch((String)"System environment variable HADOOP_TOKEN_FILE_LOCATION not found");
    }
}

