/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.boot.support;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.yarn.api.records.Container;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.web.client.RestTemplate;
import org.springframework.yarn.am.container.ContainerRegisterInfo;
import org.springframework.yarn.am.container.ContainerShutdown;

public class EndpointContainerShutdown
implements ContainerShutdown,
BeanFactoryAware {
    private static final Log log = LogFactory.getLog(EndpointContainerShutdown.class);
    private BeanFactory beanFactory;

    public boolean shutdown(Map<Container, ContainerRegisterInfo> containers) {
        log.info((Object)"Shutting down containers using boot shutdown endpoint");
        RestTemplate restTemplate = (RestTemplate)this.beanFactory.getBean("yarnRestTemplate", RestTemplate.class);
        boolean ok = true;
        for (Map.Entry<Container, ContainerRegisterInfo> entry : containers.entrySet()) {
            Container c = entry.getKey();
            ContainerRegisterInfo i = entry.getValue();
            String url = i.getTrackUrl() + "/shutdown";
            log.info((Object)("Shutting down container=[" + c + "] using url=[" + url + "]"));
            try {
                restTemplate.postForObject(url, null, Void.class, new Object[0]);
            }
            catch (Exception e) {
                log.warn((Object)("Error shutting down container=[" + c + "]"));
                ok = false;
            }
        }
        return ok;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

