/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.integration.ip.mind;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.yarn.am.GenericRpcMessage;
import org.springframework.yarn.am.RpcMessage;
import org.springframework.yarn.integration.IntegrationAppmasterServiceClient;
import org.springframework.yarn.integration.ip.mind.AppmasterMindScOperations;
import org.springframework.yarn.integration.ip.mind.MindRpcMessageHolder;
import org.springframework.yarn.integration.ip.mind.binding.BaseObject;
import org.springframework.yarn.integration.ip.mind.binding.BaseResponseObject;

public abstract class MindAppmasterServiceClient
extends IntegrationAppmasterServiceClient<MindRpcMessageHolder>
implements AppmasterMindScOperations {
    private static final Log log = LogFactory.getLog(MindAppmasterServiceClient.class);

    @Override
    public BaseResponseObject doMindRequest(BaseObject request) {
        try {
            GenericRpcMessage message = new GenericRpcMessage((Object)request);
            RpcMessage<?> rpcMessage = this.get((RpcMessage<?>)message);
            return this.getBaseResponseObject(rpcMessage);
        }
        catch (Exception e) {
            log.error((Object)"error", (Throwable)e);
            return null;
        }
    }

    protected abstract BaseResponseObject getBaseResponseObject(RpcMessage<?> var1);

    @Override
    public MindRpcMessageHolder getPayload(RpcMessage<?> message) {
        Object body = message.getBody();
        if (body instanceof MindRpcMessageHolder) {
            return (MindRpcMessageHolder)body;
        }
        ConversionService conversionService = this.getConversionService();
        if (conversionService != null) {
            return (MindRpcMessageHolder)conversionService.convert(body, MindRpcMessageHolder.class);
        }
        return null;
    }
}

