/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.support;

import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.yarn.test.context.YarnCluster;
import org.springframework.yarn.test.support.StandaloneYarnCluster;

public class YarnClusterFactoryBean
implements InitializingBean,
DisposableBean,
FactoryBean<YarnCluster> {
    private StandaloneYarnCluster cluster;
    private String clusterId;
    private boolean autoStart;
    private int nodes = 1;

    public StandaloneYarnCluster getObject() throws Exception {
        return this.cluster;
    }

    public Class<YarnCluster> getObjectType() {
        return YarnCluster.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.clusterId, (String)"Cluster id must be set");
        this.cluster = new StandaloneYarnCluster(this.clusterId, this.nodes);
        if (this.autoStart) {
            this.cluster.start();
        }
    }

    public void destroy() throws Exception {
        if (this.cluster != null) {
            this.cluster.stop();
        }
    }

    public void setClusterId(String clusterId) {
        this.clusterId = clusterId;
    }

    public void setAutoStart(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void setNodes(int nodes) {
        this.nodes = nodes;
    }
}

