/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.context;

import java.lang.annotation.Annotation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

abstract class MetaAnnotationUtils {
    private MetaAnnotationUtils() {
    }

    public static <T extends Annotation> AnnotationDescriptor<T> findAnnotationDescriptor(Class<?> clazz, Class<T> annotationType) {
        Assert.notNull(annotationType, (String)"Annotation type must not be null");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        if (AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) {
            return new AnnotationDescriptor<T>(clazz, clazz.getAnnotation(annotationType));
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            for (Annotation composedAnnotation : clazz.getAnnotations()) {
                T annotation = composedAnnotation.annotationType().getAnnotation(annotationType);
                if (annotation == null) continue;
                return new AnnotationDescriptor<T>(clazz, composedAnnotation, annotation);
            }
        }
        return MetaAnnotationUtils.findAnnotationDescriptor(clazz.getSuperclass(), annotationType);
    }

    public static UntypedAnnotationDescriptor findAnnotationDescriptorForTypes(Class<?> clazz, Class<? extends Annotation> ... annotationTypes) {
        MetaAnnotationUtils.assertNonEmptyAnnotationTypeArray(annotationTypes, "The list of annotation types must not be empty");
        if (clazz == null || clazz.equals(Object.class)) {
            return null;
        }
        for (Class<? extends Annotation> annotationType : annotationTypes) {
            if (!AnnotationUtils.isAnnotationDeclaredLocally(annotationType, clazz)) continue;
            return new UntypedAnnotationDescriptor(clazz, clazz.getAnnotation(annotationType));
        }
        if (!Annotation.class.isAssignableFrom(clazz)) {
            for (Annotation composedAnnotation : clazz.getAnnotations()) {
                for (Class<? extends Annotation> annotationType : annotationTypes) {
                    Annotation annotation = composedAnnotation.annotationType().getAnnotation(annotationType);
                    if (annotation == null) continue;
                    return new UntypedAnnotationDescriptor(clazz, composedAnnotation, annotation);
                }
            }
        }
        return MetaAnnotationUtils.findAnnotationDescriptorForTypes(clazz.getSuperclass(), annotationTypes);
    }

    private static void assertNonEmptyAnnotationTypeArray(Class<?>[] annotationTypes, String message) {
        if (ObjectUtils.isEmpty((Object[])annotationTypes)) {
            throw new IllegalArgumentException(message);
        }
        for (Class<?> clazz : annotationTypes) {
            if (Annotation.class.isAssignableFrom(clazz)) continue;
            throw new IllegalArgumentException("Array elements must be of type Annotation");
        }
    }

    public static class UntypedAnnotationDescriptor
    extends AnnotationDescriptor<Annotation> {
        public UntypedAnnotationDescriptor(Class<?> declaringClass, Annotation annotation) {
            super(declaringClass, annotation);
        }

        public UntypedAnnotationDescriptor(Class<?> declaringClass, Annotation composedAnnotation, Annotation annotation) {
            super(declaringClass, composedAnnotation, annotation);
        }
    }

    public static class AnnotationDescriptor<T extends Annotation> {
        private final Class<?> rootDeclaringClass;
        private final Class<?> declaringClass;
        private final Annotation composedAnnotation;
        private final T annotation;
        private final AnnotationAttributes annotationAttributes;

        public AnnotationDescriptor(Class<?> rootDeclaringClass, T annotation) {
            this(rootDeclaringClass, null, annotation);
        }

        public AnnotationDescriptor(Class<?> rootDeclaringClass, Annotation composedAnnotation, T annotation) {
            Assert.notNull(rootDeclaringClass, (String)"rootDeclaringClass must not be null");
            Assert.notNull(annotation, (String)"annotation must not be null");
            this.rootDeclaringClass = rootDeclaringClass;
            this.declaringClass = composedAnnotation != null ? composedAnnotation.annotationType() : rootDeclaringClass;
            this.composedAnnotation = composedAnnotation;
            this.annotation = annotation;
            this.annotationAttributes = AnnotatedElementUtils.getAnnotationAttributes(rootDeclaringClass, (String)annotation.annotationType().getName());
        }

        public Class<?> getRootDeclaringClass() {
            return this.rootDeclaringClass;
        }

        public Class<?> getDeclaringClass() {
            return this.declaringClass;
        }

        public T getAnnotation() {
            return this.annotation;
        }

        public Class<? extends Annotation> getAnnotationType() {
            return this.annotation.annotationType();
        }

        public AnnotationAttributes getAnnotationAttributes() {
            return this.annotationAttributes;
        }

        public Annotation getComposedAnnotation() {
            return this.composedAnnotation;
        }

        public Class<? extends Annotation> getComposedAnnotationType() {
            return this.composedAnnotation == null ? null : this.composedAnnotation.annotationType();
        }

        public String toString() {
            return new ToStringCreator((Object)this).append("rootDeclaringClass", this.rootDeclaringClass).append("declaringClass", this.declaringClass).append("composedAnnotation", (Object)this.composedAnnotation).append("annotation", this.annotation).toString();
        }
    }
}

