/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.yarn.test.context;

import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.test.context.MergedContextConfiguration;
import org.springframework.yarn.test.context.MetaAnnotationUtils;
import org.springframework.yarn.test.context.MiniYarnCluster;
import org.springframework.yarn.test.support.ClusterDelegatingFactoryBean;
import org.springframework.yarn.test.support.ConfigurationDelegatingFactoryBean;

abstract class YarnClusterInjectUtils {
    YarnClusterInjectUtils() {
    }

    public static void handleClusterInject(GenericApplicationContext context, MergedContextConfiguration mergedConfig) {
        Class testClass = mergedConfig.getTestClass();
        MetaAnnotationUtils.AnnotationDescriptor<MiniYarnCluster> annotationDescriptor = MetaAnnotationUtils.findAnnotationDescriptor(testClass, MiniYarnCluster.class);
        if (annotationDescriptor != null && annotationDescriptor.getAnnotation() != null) {
            String clusterName = annotationDescriptor.getAnnotationAttributes().getString("clusterName");
            String configName = annotationDescriptor.getAnnotationAttributes().getString("configName");
            String id = annotationDescriptor.getAnnotationAttributes().getString("id");
            int nodeCount = annotationDescriptor.getAnnotationAttributes().getNumber("nodes").intValue();
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(ClusterDelegatingFactoryBean.class);
            builder.addPropertyValue("id", (Object)id);
            builder.addPropertyValue("nodes", (Object)nodeCount);
            context.registerBeanDefinition(clusterName, (BeanDefinition)builder.getBeanDefinition());
            builder = BeanDefinitionBuilder.genericBeanDefinition(ConfigurationDelegatingFactoryBean.class);
            builder.addPropertyReference("cluster", clusterName);
            context.registerBeanDefinition(configName, (BeanDefinition)builder.getBeanDefinition());
        }
    }
}

