/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.management.ManageableComponent;
import flex.messaging.config.ConfigMap;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManageableComponentFactoryBean
implements FactoryBean,
BeanNameAware {
    private ConfigMap properties = new ConfigMap();
    private String beanName;
    private final Class<? extends ManageableComponent> componentClass;

    public ManageableComponentFactoryBean(Class<? extends ManageableComponent> componentClass) {
        this.componentClass = componentClass;
    }

    public Object getObject() throws Exception {
        ManageableComponent component = (ManageableComponent)BeanUtils.instantiateClass(this.componentClass);
        component.setId(this.beanName);
        component.initialize(this.beanName, this.properties);
        return component;
    }

    public Class<?> getObjectType() {
        return this.componentClass;
    }

    public final boolean isSingleton() {
        return false;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setProperties(ConfigMap properties) {
        this.properties = properties;
    }
}

