/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.core;

import flex.messaging.Destination;
import flex.messaging.MessageBroker;
import flex.messaging.services.Service;
import flex.messaging.services.ServiceAdapter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractDestinationFactory
implements InitializingBean,
DisposableBean,
BeanNameAware,
BeanFactoryAware {
    private volatile String destinationId;
    private volatile String beanName;
    private String[] channels;
    private MessageBroker broker;
    private BeanFactory beanFactory;
    private String serviceAdapter;

    public final void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.broker, (String)"The 'messageBroker' property is required.");
        Destination destination = this.createDestination(this.getDestinationId(), this.broker);
        this.configureAdapter(destination);
        this.configureChannels(destination);
        this.initializeDestination(destination);
    }

    public final void destroy() throws Exception {
        if (this.broker == null || !this.broker.isStarted()) {
            return;
        }
        this.destroyDestination(this.getDestinationId(), this.broker);
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setChannels(String[] channels) {
        this.channels = StringUtils.trimArrayElements((String[])channels);
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public void setMessageBroker(MessageBroker broker) {
        this.broker = broker;
    }

    public void setServiceAdapter(String serviceAdapter) {
        this.serviceAdapter = serviceAdapter;
    }

    protected void configureAdapter(Destination destination) {
        String adapterId;
        String string = adapterId = StringUtils.hasText((String)this.serviceAdapter) ? this.serviceAdapter : this.getTargetService(this.broker).getDefaultAdapter();
        if (this.beanFactory.containsBean(adapterId)) {
            ServiceAdapter adapter = (ServiceAdapter)this.beanFactory.getBean(adapterId, ServiceAdapter.class);
            destination.setAdapter(adapter);
        } else if (destination.getAdapter() == null) {
            destination.createAdapter(adapterId);
        }
    }

    protected abstract Destination createDestination(String var1, MessageBroker var2) throws Exception;

    protected abstract void destroyDestination(String var1, MessageBroker var2) throws Exception;

    protected String getDestinationId() {
        return StringUtils.hasText((String)this.destinationId) ? this.destinationId : this.beanName;
    }

    protected abstract Service getTargetService(MessageBroker var1);

    protected abstract void initializeDestination(Destination var1) throws Exception;

    private void configureChannels(Destination destination) {
        if (ObjectUtils.isEmpty((Object[])this.channels)) {
            return;
        }
        String[] stringArray = this.channels;
        int n = this.channels.length;
        int n2 = 0;
        while (n2 < n) {
            String channelId = stringArray[n2];
            Assert.isTrue((boolean)this.broker.getChannelIds().contains(channelId), (String)("The channel " + channelId + " is not known to the MessageBroker " + this.broker.getId() + " and cannot be set on the destination " + this.getDestinationId()));
            ++n2;
        }
        destination.setChannels(CollectionUtils.arrayToList((Object)this.channels));
    }
}

