/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.security;

import flex.messaging.endpoints.AbstractEndpoint;
import flex.messaging.messages.CommandMessage;
import flex.messaging.messages.Message;
import org.springframework.flex.core.MessageInterceptor;
import org.springframework.flex.core.MessageProcessingContext;
import org.springframework.flex.security.EndpointDefinitionSource;
import org.springframework.security.intercept.AbstractSecurityInterceptor;
import org.springframework.security.intercept.InterceptorStatusToken;
import org.springframework.security.intercept.ObjectDefinitionSource;

public class EndpointInterceptor
extends AbstractSecurityInterceptor
implements MessageInterceptor {
    private static final String STATUS_TOKEN = "_enpointInterceptorStatusToken";
    private EndpointDefinitionSource objectDefinitionSource;

    public EndpointDefinitionSource getObjectDefinitionSource() {
        return this.objectDefinitionSource;
    }

    public Class getSecureObjectClass() {
        return AbstractEndpoint.class;
    }

    public ObjectDefinitionSource obtainObjectDefinitionSource() {
        return this.objectDefinitionSource;
    }

    public Message postProcess(MessageProcessingContext context, Message inputMessage, Message outputMessage) {
        if (context.getAttributes().containsKey(STATUS_TOKEN)) {
            InterceptorStatusToken token = (InterceptorStatusToken)context.getAttributes().get(STATUS_TOKEN);
            return (Message)this.afterInvocation(token, outputMessage);
        }
        return outputMessage;
    }

    public Message preProcess(MessageProcessingContext context, Message inputMessage) {
        if (!this.isPassThroughCommand(inputMessage)) {
            InterceptorStatusToken token = this.beforeInvocation(context.getMessageTarget());
            context.getAttributes().put(STATUS_TOKEN, token);
        }
        return inputMessage;
    }

    public void setObjectDefinitionSource(EndpointDefinitionSource newSource) {
        this.objectDefinitionSource = newSource;
    }

    private boolean isPassThroughCommand(Message message) {
        if (message instanceof CommandMessage) {
            CommandMessage command = (CommandMessage)message;
            return command.getOperation() == 5 || command.getOperation() == 8;
        }
        return false;
    }
}

