/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.flex.config;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.springframework.flex.remoting.RemotingDestination;
import org.springframework.flex.remoting.RemotingExclude;
import org.springframework.flex.remoting.RemotingInclude;
import org.springframework.util.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RemotingDestinationMetadata {
    private final RemotingDestination remotingDestination;
    private final String beanName;
    private final String[] excludeMethods;
    private final String[] includeMethods;

    RemotingDestinationMetadata(RemotingDestination remotingDestination, String beanName, Class<?> beanType) {
        this.remotingDestination = remotingDestination;
        this.beanName = beanName;
        this.excludeMethods = this.extractExcludeMethods(beanType);
        this.includeMethods = this.extractIncludeMethods(beanType);
    }

    public String getBeanName() {
        return this.beanName;
    }

    public String[] getExcludeMethods() {
        return this.excludeMethods;
    }

    public String[] getIncludeMethods() {
        return this.includeMethods;
    }

    public RemotingDestination getRemotingDestination() {
        return this.remotingDestination;
    }

    private String[] extractExcludeMethods(Class<?> serviceClass) {
        final HashSet excludes = new HashSet();
        ReflectionUtils.doWithMethods(serviceClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                excludes.add(method.getName());
            }
        }, (ReflectionUtils.MethodFilter)new FlexExcludeFilter());
        return excludes.toArray(new String[excludes.size()]);
    }

    private String[] extractIncludeMethods(Class<?> serviceClass) {
        final HashSet includes = new HashSet();
        ReflectionUtils.doWithMethods(serviceClass, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

            public void doWith(Method method) throws IllegalArgumentException, IllegalAccessException {
                includes.add(method.getName());
            }
        }, (ReflectionUtils.MethodFilter)new FlexIncludeFilter());
        return includes.toArray(new String[includes.size()]);
    }

    private static class FlexExcludeFilter
    implements ReflectionUtils.MethodFilter {
        private FlexExcludeFilter() {
        }

        public boolean matches(Method method) {
            return method.getAnnotation(RemotingExclude.class) != null;
        }
    }

    private static class FlexIncludeFilter
    implements ReflectionUtils.MethodFilter {
        private FlexIncludeFilter() {
        }

        public boolean matches(Method method) {
            return method.getAnnotation(RemotingInclude.class) != null;
        }
    }
}

